/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class DefaultServicePool<Key, Service>
extends ServiceSupport
implements ServicePool<Key, Service> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ConcurrentMap<Key, BlockingQueue<Service>> pool = new ConcurrentHashMap<Key, BlockingQueue<Service>>();
    protected int capacity = 100;

    protected DefaultServicePool() {
    }

    public DefaultServicePool(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public synchronized int size() {
        int size2 = 0;
        for (BlockingQueue entry : this.pool.values()) {
            size2 += entry.size();
        }
        return size2;
    }

    @Override
    public synchronized Service addAndAcquire(Key key, Service service) {
        ArrayBlockingQueue entry = (ArrayBlockingQueue)this.pool.get(key);
        if (entry == null) {
            entry = new ArrayBlockingQueue(this.capacity);
            this.pool.put(key, entry);
        }
        this.log.trace("AddAndAcquire key: {} service: {}", (Object)key, (Object)service);
        if (entry.size() >= this.capacity) {
            throw new IllegalStateException("Queue full");
        }
        return service;
    }

    @Override
    public synchronized Service acquire(Key key) {
        BlockingQueue services = (BlockingQueue)this.pool.get(key);
        if (services == null || services.isEmpty()) {
            this.log.trace("No free services in pool to acquire for key: {}", (Object)key);
            return null;
        }
        Object answer = services.poll();
        this.log.trace("Acquire: {} service: {}", (Object)key, answer);
        return (Service)answer;
    }

    @Override
    public synchronized void release(Key key, Service service) {
        this.log.trace("Release: {} service: {}", (Object)key, (Object)service);
        BlockingQueue services = (BlockingQueue)this.pool.get(key);
        if (services != null) {
            services.add(service);
        }
    }

    @Override
    public void purge() {
        this.pool.clear();
    }

    @Override
    protected void doStart() throws Exception {
        this.log.debug("Starting service pool: {}", (Object)this);
    }

    @Override
    protected void doStop() throws Exception {
        this.log.debug("Stopping service pool: {}", (Object)this);
        for (BlockingQueue entry : this.pool.values()) {
            ArrayList values = new ArrayList();
            entry.drainTo(values);
            ServiceHelper.stopServices(values);
            entry.clear();
        }
        this.pool.clear();
    }
}

