/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import org.apache.atlas.AtlasException;
import org.apache.atlas.security.InMemoryJAASConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationProperties
extends PropertiesConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String APPLICATION_PROPERTIES = "atlas-application.properties";
    private static volatile Configuration instance = null;

    private ApplicationProperties(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forceReload() {
        if (instance == null) return;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (instance == null) return;
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration get() throws AtlasException {
        if (instance != null) return instance;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (instance != null) return instance;
            instance = ApplicationProperties.get(APPLICATION_PROPERTIES);
            InMemoryJAASConfiguration.init(instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static Configuration get(String fileName) throws AtlasException {
        String confLocation = System.getProperty("atlas.conf");
        try {
            URL url = null;
            if (confLocation == null) {
                LOG.info("Looking for {} in classpath", (Object)fileName);
                url = ApplicationProperties.class.getClassLoader().getResource(fileName);
                if (url == null) {
                    LOG.info("Looking for /{} in classpath", (Object)fileName);
                    url = ApplicationProperties.class.getClassLoader().getResource("/" + fileName);
                }
            } else {
                url = new File(confLocation, fileName).toURI().toURL();
            }
            LOG.info("Loading {} from {}", (Object)fileName, (Object)url);
            Configuration configuration = new ApplicationProperties(url).interpolatedConfiguration();
            ApplicationProperties.logConfiguration(configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new AtlasException("Failed to load application properties", e);
        }
    }

    private static void logConfiguration(Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            Iterator keys = configuration.getKeys();
            LOG.debug("Configuration loaded:");
            while (keys.hasNext()) {
                String key = (String)keys.next();
                LOG.debug("{} = {}", (Object)key, configuration.getProperty(key));
            }
        }
    }

    public static Configuration getSubsetConfiguration(Configuration inConf, String prefix) {
        return inConf.subset(prefix);
    }

    public static Class getClass(Configuration configuration, String propertyName, String defaultValue, Class assignableClass) throws AtlasException {
        try {
            String propertyValue = configuration.getString(propertyName, defaultValue);
            Class<?> clazz = Class.forName(propertyValue);
            if (assignableClass == null || assignableClass.isAssignableFrom(clazz)) {
                return clazz;
            }
            String message = "Class " + clazz.getName() + " specified in property " + propertyName + " is not assignable to class " + assignableClass.getName();
            LOG.error(message);
            throw new AtlasException(message);
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }
}

