/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.notification.HookNotification;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.typedef.TypesDef;

public class HookNotificationV1 {

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityDeleteRequest
    extends HookNotification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String typeName;
        private String attribute;
        private String attributeValue;

        public EntityDeleteRequest() {
        }

        public EntityDeleteRequest(String user, String typeName, String attribute, String attributeValue) {
            this(HookNotification.HookNotificationType.ENTITY_DELETE, user, typeName, attribute, attributeValue);
        }

        protected EntityDeleteRequest(HookNotification.HookNotificationType type, String user, String typeName, String attribute, String attributeValue) {
            super(type, user);
            this.typeName = typeName;
            this.attribute = attribute;
            this.attributeValue = attributeValue;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("EntityDeleteRequest{");
            super.toString(sb);
            sb.append("typeName=").append(this.typeName);
            sb.append("attribute=").append(this.attribute);
            sb.append("attributeValue=").append(this.attributeValue);
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityPartialUpdateRequest
    extends HookNotification {
        private static final long serialVersionUID = 1L;
        private String typeName;
        private String attribute;
        private String attributeValue;
        private Referenceable entity;

        public EntityPartialUpdateRequest() {
        }

        public EntityPartialUpdateRequest(String user, String typeName, String attribute, String attributeValue, Referenceable entity) {
            super(HookNotification.HookNotificationType.ENTITY_PARTIAL_UPDATE, user);
            this.typeName = typeName;
            this.attribute = attribute;
            this.attributeValue = attributeValue;
            this.entity = entity;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public Referenceable getEntity() {
            return this.entity;
        }

        public void setEntity(Referenceable entity) {
            this.entity = entity;
        }

        @Override
        public void normalize() {
            super.normalize();
            if (this.entity != null) {
                this.entity.normalize();
            }
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("EntityPartialUpdateRequest{");
            super.toString(sb);
            sb.append("typeName=").append(this.typeName);
            sb.append("attribute=").append(this.attribute);
            sb.append("attributeValue=").append(this.attributeValue);
            sb.append("entity=");
            if (this.entity != null) {
                this.entity.toString(sb);
            }
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityUpdateRequest
    extends EntityCreateRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public EntityUpdateRequest() {
        }

        public EntityUpdateRequest(String user, Referenceable ... entities) {
            this(user, Arrays.asList(entities));
        }

        public EntityUpdateRequest(String user, List<Referenceable> entities) {
            super(HookNotification.HookNotificationType.ENTITY_FULL_UPDATE, entities, user);
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("EntityUpdateRequest{");
            super.toString(sb);
            sb.append("entities=[");
            AtlasBaseTypeDef.dumpObjects(this.getEntities(), sb);
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityCreateRequest
    extends HookNotification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Referenceable> entities;

        public EntityCreateRequest() {
        }

        public EntityCreateRequest(String user, Referenceable ... entities) {
            this(HookNotification.HookNotificationType.ENTITY_CREATE, Arrays.asList(entities), user);
        }

        public EntityCreateRequest(String user, List<Referenceable> entities) {
            this(HookNotification.HookNotificationType.ENTITY_CREATE, entities, user);
        }

        protected EntityCreateRequest(HookNotification.HookNotificationType type, List<Referenceable> entities, String user) {
            super(type, user);
            this.entities = entities;
        }

        public List<Referenceable> getEntities() {
            return this.entities;
        }

        public void setEntities(List<Referenceable> entities) {
            this.entities = entities;
        }

        @Override
        public void normalize() {
            super.normalize();
            if (this.entities != null) {
                for (Referenceable entity : this.entities) {
                    if (entity == null) continue;
                    entity.normalize();
                }
            }
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("EntityCreateRequest{");
            super.toString(sb);
            sb.append("entities=[");
            AtlasBaseTypeDef.dumpObjects(this.getEntities(), sb);
            sb.append("]");
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class TypeRequest
    extends HookNotification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private TypesDef typesDef;

        public TypeRequest() {
        }

        public TypeRequest(HookNotification.HookNotificationType type, TypesDef typesDef, String user) {
            super(type, user);
            this.typesDef = typesDef;
        }

        public TypesDef getTypesDef() {
            return this.typesDef;
        }

        public void setTypesDef(TypesDef typesDef) {
            this.typesDef = typesDef;
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("TypeRequest{");
            super.toString(sb);
            sb.append("typesDef=");
            if (this.typesDef != null) {
                this.typesDef.toString(sb);
            }
            sb.append("}");
            return sb;
        }
    }
}

