/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.v1.model.typedef.Multiplicity;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AttributeDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String dataTypeName;
    private Multiplicity multiplicity;
    private boolean isComposite;
    private boolean isUnique;
    private boolean isIndexable;
    private String reverseAttributeName;
    private String defaultValue;
    private String description;
    private Map<String, String> options;
    private int searchWeight = -1;
    private AtlasStructDef.AtlasAttributeDef.IndexType indexType = null;

    public AttributeDefinition() {
    }

    public AttributeDefinition(String name, String dataTypeName, Multiplicity multiplicity) {
        this(name, dataTypeName, multiplicity, false, false, true, null, null, -1, null);
    }

    public AttributeDefinition(String name, String dataTypeName, Multiplicity multiplicity, boolean isComposite, String reverseAttributeName) {
        this(name, dataTypeName, multiplicity, isComposite, reverseAttributeName, -1, null);
    }

    public AttributeDefinition(String name, String dataTypeName, Multiplicity multiplicity, boolean isComposite, String reverseAttributeName, int searchWeight, AtlasStructDef.AtlasAttributeDef.IndexType indexType) {
        this(name, dataTypeName, multiplicity, isComposite, false, false, reverseAttributeName, null, searchWeight, indexType);
    }

    public AttributeDefinition(String name, String dataTypeName, Multiplicity multiplicity, boolean isComposite, boolean isUnique, boolean isIndexable, String reverseAttributeName, Map<String, String> options) {
        this(name, dataTypeName, multiplicity, isComposite, isUnique, isIndexable, reverseAttributeName, options, -1, null);
    }

    public AttributeDefinition(String name, String dataTypeName, Multiplicity multiplicity, boolean isComposite, boolean isUnique, boolean isIndexable, String reverseAttributeName, Map<String, String> options, int searchWeight, AtlasStructDef.AtlasAttributeDef.IndexType indexType) {
        this.name = name;
        this.dataTypeName = dataTypeName;
        this.multiplicity = multiplicity;
        this.isComposite = isComposite;
        this.isUnique = isUnique;
        this.isIndexable = isIndexable;
        this.reverseAttributeName = reverseAttributeName;
        this.options = options;
        this.searchWeight = searchWeight;
        this.indexType = indexType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setDataTypeName(String dataTypeName) {
        this.dataTypeName = dataTypeName;
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(Multiplicity multiplicity) {
        this.multiplicity = multiplicity;
    }

    public boolean getIsComposite() {
        return this.isComposite;
    }

    public void setIsComposite(boolean isComposite) {
        this.isComposite = isComposite;
    }

    public boolean getIsUnique() {
        return this.isUnique;
    }

    public void setIsUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public boolean getIsIndexable() {
        return this.isIndexable;
    }

    public void setIsIndexable(boolean isIndexable) {
        this.isIndexable = isIndexable;
    }

    public String getReverseAttributeName() {
        return this.reverseAttributeName;
    }

    public void setReverseAttributeName(String reverseAttributeName) {
        this.reverseAttributeName = reverseAttributeName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options != null ? new HashMap<String, String>(options) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        return this.isComposite == that.isComposite && this.isUnique == that.isUnique && this.isIndexable == that.isIndexable && Objects.equals(this.name, that.name) && Objects.equals(this.dataTypeName, that.dataTypeName) && Objects.equals(this.multiplicity, that.multiplicity) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.description, that.description) && Objects.equals(this.reverseAttributeName, that.reverseAttributeName) && Objects.equals(this.options, that.options) && Objects.equals(this.searchWeight, that.searchWeight);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataTypeName, this.multiplicity, this.isComposite, this.isUnique, this.isIndexable, this.reverseAttributeName, this.defaultValue, this.description, this.options, this.searchWeight);
    }

    public void setSearchWeight(int searchWeight) {
        this.searchWeight = searchWeight;
    }

    public int getSearchWeight() {
        return this.searchWeight;
    }

    public void setIndexType(AtlasStructDef.AtlasAttributeDef.IndexType indexType) {
        this.indexType = indexType;
    }

    public AtlasStructDef.AtlasAttributeDef.IndexType getIndexType() {
        return this.indexType;
    }
}

