/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.atlas.AtlasException;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    private static final Logger LOG = LoggerFactory.getLogger(RequestContext.class);
    private static final ThreadLocal<RequestContext> CURRENT_CONTEXT = new ThreadLocal();
    private Set<String> createdEntityIds = new LinkedHashSet<String>();
    private Set<String> updatedEntityIds = new LinkedHashSet<String>();
    private Set<String> deletedEntityIds = new LinkedHashSet<String>();
    private List<ITypedReferenceableInstance> deletedEntities = new ArrayList<ITypedReferenceableInstance>();
    private String user;
    private long requestTime;
    TypeSystem typeSystem = TypeSystem.getInstance();

    private RequestContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RequestContext get() {
        if (CURRENT_CONTEXT.get() != null) return CURRENT_CONTEXT.get();
        Class<RequestContext> clazz = RequestContext.class;
        synchronized (RequestContext.class) {
            if (CURRENT_CONTEXT.get() != null) return CURRENT_CONTEXT.get();
            RequestContext.createContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CURRENT_CONTEXT.get();
        }
    }

    public static RequestContext createContext() {
        RequestContext context = new RequestContext();
        context.requestTime = System.currentTimeMillis();
        CURRENT_CONTEXT.set(context);
        return context;
    }

    public static void clear() {
        CURRENT_CONTEXT.remove();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void recordEntityCreate(Collection<String> createdEntityIds) {
        this.createdEntityIds.addAll(createdEntityIds);
    }

    public void recordEntityUpdate(Collection<String> updatedEntityIds) {
        this.updatedEntityIds.addAll(updatedEntityIds);
    }

    public void recordEntityUpdate(String entityId) {
        this.updatedEntityIds.add(entityId);
    }

    public void recordEntityDelete(String entityId, String typeName) throws AtlasException {
        ClassType type = (ClassType)this.typeSystem.getDataType(ClassType.class, typeName);
        ITypedReferenceableInstance entity = type.createInstance(new Id(entityId, 0, typeName), new String[0]);
        if (this.deletedEntityIds.add(entityId)) {
            this.deletedEntities.add(entity);
        }
    }

    public List<String> getCreatedEntityIds() {
        return new ArrayList<String>(this.createdEntityIds);
    }

    public List<String> getUpdatedEntityIds() {
        return new ArrayList<String>(this.updatedEntityIds);
    }

    public List<String> getDeletedEntityIds() {
        return new ArrayList<String>(this.deletedEntityIds);
    }

    public List<ITypedReferenceableInstance> getDeletedEntities() {
        return this.deletedEntities;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public boolean isDeletedEntity(String entityGuid) {
        return this.deletedEntityIds.contains(entityGuid);
    }
}

