/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;

public final class UDHelper {
    private static final MethodHandle methodParseOne;
    private static final CodecRegistry codecRegistry;

    static TypeCodec<Object>[] codecsFor(DataType[] dataType) {
        TypeCodec[] codecs = new TypeCodec[dataType.length];
        for (int i = 0; i < dataType.length; ++i) {
            codecs[i] = UDHelper.codecFor(dataType[i]);
        }
        return codecs;
    }

    public static TypeCodec<Object> codecFor(DataType dataType) {
        return codecRegistry.codecFor(dataType);
    }

    public static TypeToken<?>[] typeTokens(TypeCodec<Object>[] dataTypes, boolean calledOnNullInput) {
        TypeToken[] paramTypes = new TypeToken[dataTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            TypeToken typeToken = dataTypes[i].getJavaType();
            if (!calledOnNullInput) {
                Class clazz = typeToken.getRawType();
                if (clazz == Integer.class) {
                    typeToken = TypeToken.of(Integer.TYPE);
                } else if (clazz == Long.class) {
                    typeToken = TypeToken.of(Long.TYPE);
                } else if (clazz == Byte.class) {
                    typeToken = TypeToken.of(Byte.TYPE);
                } else if (clazz == Short.class) {
                    typeToken = TypeToken.of(Short.TYPE);
                } else if (clazz == Float.class) {
                    typeToken = TypeToken.of(Float.TYPE);
                } else if (clazz == Double.class) {
                    typeToken = TypeToken.of(Double.TYPE);
                } else if (clazz == Boolean.class) {
                    typeToken = TypeToken.of(Boolean.TYPE);
                }
            }
            paramTypes[i] = typeToken;
        }
        return paramTypes;
    }

    public static DataType[] driverTypes(List<AbstractType<?>> abstractTypes) {
        DataType[] argDataTypes = new DataType[abstractTypes.size()];
        for (int i = 0; i < argDataTypes.length; ++i) {
            argDataTypes[i] = UDHelper.driverType(abstractTypes.get(i));
        }
        return argDataTypes;
    }

    public static DataType driverType(AbstractType abstractType) {
        CQL3Type cqlType = abstractType.asCQL3Type();
        String abstractTypeDef = cqlType.getType().toString();
        return UDHelper.driverTypeFromAbstractType(abstractTypeDef);
    }

    public static DataType driverTypeFromAbstractType(String abstractTypeDef) {
        try {
            return methodParseOne.invoke(abstractTypeDef, ProtocolVersion.fromInt((int)org.apache.cassandra.transport.ProtocolVersion.CURRENT.asInt()), codecRegistry);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("cannot parse driver type " + abstractTypeDef, e);
        }
    }

    public static Object deserialize(TypeCodec<?> codec, org.apache.cassandra.transport.ProtocolVersion protocolVersion, ByteBuffer value) {
        return codec.deserialize(value, ProtocolVersion.fromInt((int)protocolVersion.asInt()));
    }

    public static ByteBuffer serialize(TypeCodec<?> codec, org.apache.cassandra.transport.ProtocolVersion protocolVersion, Object value) {
        if (!codec.getJavaType().getRawType().isAssignableFrom(value.getClass())) {
            throw new InvalidTypeException("Invalid value for CQL type " + codec.getCqlType().getName().toString());
        }
        return codec.serialize(value, ProtocolVersion.fromInt((int)protocolVersion.asInt()));
    }

    public static Class<?> asJavaClass(TypeCodec<?> codec) {
        return codec.getJavaType().getRawType();
    }

    public static boolean isNullOrEmpty(AbstractType<?> type, ByteBuffer bb) {
        return bb == null || bb.remaining() == 0 && type.isEmptyValueMeaningless();
    }

    static {
        try {
            Class<?> cls = Class.forName("com.datastax.driver.core.DataTypeClassNameParser");
            Method m = cls.getDeclaredMethod("parseOne", String.class, ProtocolVersion.class, CodecRegistry.class);
            m.setAccessible(true);
            methodParseOne = MethodHandles.lookup().unreflect(m);
            codecRegistry = new CodecRegistry();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

