/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.DataInput;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileSegmentInputStream;

public class EncryptedFileSegmentInputStream
extends FileSegmentInputStream
implements FileDataInput,
DataInput {
    private final long segmentOffset;
    private final int expectedLength;
    private final ChunkProvider chunkProvider;
    private int totalChunkOffset;

    public EncryptedFileSegmentInputStream(String filePath, long segmentOffset, int position, int expectedLength, ChunkProvider chunkProvider) {
        super(chunkProvider.nextChunk(), filePath, (long)position);
        this.segmentOffset = segmentOffset;
        this.expectedLength = expectedLength;
        this.chunkProvider = chunkProvider;
    }

    @Override
    public long getFilePointer() {
        return this.segmentOffset + (long)this.totalChunkOffset + (long)this.buffer.position();
    }

    @Override
    public boolean isEOF() {
        return this.totalChunkOffset + this.buffer.position() >= this.expectedLength;
    }

    @Override
    public long bytesRemaining() {
        return this.expectedLength - (this.totalChunkOffset + this.buffer.position());
    }

    @Override
    public void seek(long position) {
        long bufferPos = position - (long)this.totalChunkOffset - this.segmentOffset;
        while (this.buffer != null && bufferPos > (long)this.buffer.capacity()) {
            this.buffer.position(this.buffer.limit());
            this.reBuffer();
            bufferPos = position - (long)this.totalChunkOffset - this.segmentOffset;
        }
        if (this.buffer == null || bufferPos < 0L || bufferPos > (long)this.buffer.capacity()) {
            throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in partial mode", position, this.getPath(), this.segmentOffset + (long)this.expectedLength));
        }
        this.buffer.position((int)bufferPos);
    }

    @Override
    public long bytesPastMark(DataPosition mark) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reBuffer() {
        this.totalChunkOffset += this.buffer.position();
        this.buffer = this.chunkProvider.nextChunk();
    }

    public static interface ChunkProvider {
        public ByteBuffer nextChunk();
    }
}

