/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.utils.trie;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.cassandra.index.sasi.utils.trie.KeyAnalyzer;
import org.apache.cassandra.index.sasi.utils.trie.Trie;
import org.apache.cassandra.index.sasi.utils.trie.Tries;

abstract class AbstractTrie<K, V>
extends AbstractMap<K, V>
implements Serializable,
Trie<K, V> {
    private static final long serialVersionUID = -6358111100045408883L;
    protected final KeyAnalyzer<? super K> keyAnalyzer;

    public AbstractTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        this.keyAnalyzer = Tries.notNull(keyAnalyzer, "keyAnalyzer");
    }

    @Override
    public K selectKey(K key) {
        Map.Entry entry = this.select(key);
        return entry != null ? (K)entry.getKey() : null;
    }

    @Override
    public V selectValue(K key) {
        Map.Entry entry = this.select(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Trie[").append(this.size()).append("]={\n");
        for (Map.Entry entry : this.entrySet()) {
            buffer.append("  ").append(entry).append("\n");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    final int lengthInBits(K key) {
        return key == null ? 0 : this.keyAnalyzer.lengthInBits(key);
    }

    final boolean isBitSet(K key, int bitIndex) {
        return key != null && this.keyAnalyzer.isBitSet(key, bitIndex);
    }

    final int bitIndex(K key, K otherKey) {
        if (key != null && otherKey != null) {
            return this.keyAnalyzer.bitIndex(key, otherKey);
        }
        if (key != null) {
            return this.bitIndex(key);
        }
        if (otherKey != null) {
            return this.bitIndex(otherKey);
        }
        return -1;
    }

    private int bitIndex(K key) {
        int lengthInBits = this.lengthInBits(key);
        for (int i = 0; i < lengthInBits; ++i) {
            if (!this.isBitSet(key, i)) continue;
            return i;
        }
        return -1;
    }

    final boolean compareKeys(K key, K other) {
        if (key == null) {
            return other == null;
        }
        if (other == null) {
            return false;
        }
        return this.keyAnalyzer.compare(key, other) == 0;
    }

    static abstract class BasicEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -944364551314110330L;
        protected K key;
        protected V value;
        private transient int hashCode = 0;

        public BasicEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public V setKeyValue(K key, V value) {
            this.key = key;
            this.hashCode = 0;
            return this.setValue(value);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V previous = this.value;
            this.value = value;
            return previous;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.key != null ? this.key.hashCode() : 0;
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return Tries.areEqual(this.key, other.getKey()) && Tries.areEqual(this.value, other.getValue());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

