/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class ClassLoaderSwitcher {
    private Log log;
    private String origClassPath;
    private Map<Object, Object> origProps;
    private ClassLoader origContextClassloader;

    public ClassLoaderSwitcher(Log log) {
        this.log = log;
    }

    public String switchClassLoader(MavenProject project, boolean useCompileClasspath, String classpath, List classpathElements) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(classpath);
            buf.append(File.pathSeparatorChar);
            urlList.add(new File(project.getBuild().getOutputDirectory()).toURI().toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        for (Object classpathElement : classpathElements) {
            buf.append(classpathElement.toString());
            buf.append(File.pathSeparatorChar);
        }
        buf.append(File.pathSeparatorChar);
        List artifacts = useCompileClasspath ? project.getCompileArtifacts() : project.getTestArtifacts();
        for (Artifact a : CastUtils.cast((List)artifacts, Artifact.class)) {
            try {
                if (a.getFile() == null || !a.getFile().exists()) continue;
                urlList.add(a.getFile().toURI().toURL());
                buf.append(a.getFile().getAbsolutePath());
                buf.append(File.pathSeparatorChar);
            }
            catch (MalformedURLException e) {}
        }
        this.origContextClassloader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), this.origContextClassloader);
        String newCp = buf.toString();
        this.log.debug((CharSequence)("Classpath: " + ((Object)urlList).toString()));
        this.origProps = new HashMap<Object, Object>(System.getProperties());
        this.origClassPath = System.getProperty("java.class.path");
        Thread.currentThread().setContextClassLoader(loader);
        System.setProperty("java.class.path", newCp);
        return newCp;
    }

    public void restoreClassLoader() {
        Thread.currentThread().setContextClassLoader(this.origContextClassloader);
        System.setProperty("java.class.path", this.origClassPath);
        HashMap<Object, Object> newProps = new HashMap<Object, Object>(System.getProperties());
        for (Object o : newProps.keySet()) {
            if (this.origProps.containsKey(o)) continue;
            System.clearProperty(o.toString());
        }
        System.getProperties().putAll(this.origProps);
        this.origContextClassloader = null;
    }
}

