/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.policy.AssertionBuilderLoader;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderLoader;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertionBuilder;
import org.apache.cxf.ws.security.policy.custom.AlgorithmSuiteBuilder;
import org.apache.cxf.ws.security.policy.interceptors.HttpsTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.IssuedTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.KerberosTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.SamlTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.SecureConversationTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.SpnegoTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.UsernameTokenInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.WSSecurityInterceptorProvider;
import org.apache.cxf.ws.security.policy.interceptors.WSSecurityPolicyInterceptorProvider;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.xml.XMLPrimitiveAssertionBuilder;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.SP13Constants;
import org.apache.wss4j.policy.builders.AsymmetricBindingBuilder;
import org.apache.wss4j.policy.builders.BootstrapPolicyBuilder;
import org.apache.wss4j.policy.builders.ContentEncryptedElementsBuilder;
import org.apache.wss4j.policy.builders.EncryptedElementsBuilder;
import org.apache.wss4j.policy.builders.EncryptedPartsBuilder;
import org.apache.wss4j.policy.builders.EncryptionTokenBuilder;
import org.apache.wss4j.policy.builders.HttpsTokenBuilder;
import org.apache.wss4j.policy.builders.InitiatorEncryptionTokenBuilder;
import org.apache.wss4j.policy.builders.InitiatorSignatureTokenBuilder;
import org.apache.wss4j.policy.builders.InitiatorTokenBuilder;
import org.apache.wss4j.policy.builders.IssuedTokenBuilder;
import org.apache.wss4j.policy.builders.KerberosTokenBuilder;
import org.apache.wss4j.policy.builders.KeyValueTokenBuilder;
import org.apache.wss4j.policy.builders.LayoutBuilder;
import org.apache.wss4j.policy.builders.ProtectionTokenBuilder;
import org.apache.wss4j.policy.builders.RecipientEncryptionTokenBuilder;
import org.apache.wss4j.policy.builders.RecipientSignatureTokenBuilder;
import org.apache.wss4j.policy.builders.RecipientTokenBuilder;
import org.apache.wss4j.policy.builders.RequiredElementsBuilder;
import org.apache.wss4j.policy.builders.RequiredPartsBuilder;
import org.apache.wss4j.policy.builders.SamlTokenBuilder;
import org.apache.wss4j.policy.builders.SecureConversationTokenBuilder;
import org.apache.wss4j.policy.builders.SecurityContextTokenBuilder;
import org.apache.wss4j.policy.builders.SignatureTokenBuilder;
import org.apache.wss4j.policy.builders.SignedElementsBuilder;
import org.apache.wss4j.policy.builders.SignedPartsBuilder;
import org.apache.wss4j.policy.builders.SpnegoContextTokenBuilder;
import org.apache.wss4j.policy.builders.SupportingTokensBuilder;
import org.apache.wss4j.policy.builders.SymmetricBindingBuilder;
import org.apache.wss4j.policy.builders.TransportBindingBuilder;
import org.apache.wss4j.policy.builders.TransportTokenBuilder;
import org.apache.wss4j.policy.builders.Trust10Builder;
import org.apache.wss4j.policy.builders.Trust13Builder;
import org.apache.wss4j.policy.builders.UsernameTokenBuilder;
import org.apache.wss4j.policy.builders.WSS10Builder;
import org.apache.wss4j.policy.builders.WSS11Builder;
import org.apache.wss4j.policy.builders.X509TokenBuilder;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.w3c.dom.Element;

@NoJSR250Annotations
public final class WSSecurityPolicyLoader
implements PolicyInterceptorProviderLoader,
AssertionBuilderLoader {
    private static final Logger LOG = LogUtils.getL7dLogger(WSSecurityPolicyLoader.class);
    Bus bus;

    public WSSecurityPolicyLoader(Bus b) {
        this.bus = b;
        this.registerBuilders();
        try {
            this.registerProviders();
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Could not load or register WS-SecurityPolicy related classes.", t);
        }
    }

    public void registerBuilders() {
        AssertionBuilderRegistry reg = (AssertionBuilderRegistry)this.bus.getExtension(AssertionBuilderRegistry.class);
        if (reg == null) {
            return;
        }
        reg.registerBuilder((AssertionBuilder)new AlgorithmSuiteBuilder(this.bus));
        reg.registerBuilder((AssertionBuilder)new AsymmetricBindingBuilder());
        reg.registerBuilder((AssertionBuilder)new ContentEncryptedElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new EncryptedElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new EncryptionTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new EncryptedPartsBuilder());
        reg.registerBuilder((AssertionBuilder)new HttpsTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new InitiatorTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new InitiatorSignatureTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new InitiatorEncryptionTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new IssuedTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new LayoutBuilder());
        reg.registerBuilder((AssertionBuilder)new ProtectionTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new RecipientTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new RecipientSignatureTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new RecipientEncryptionTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new RequiredElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new RequiredPartsBuilder());
        reg.registerBuilder((AssertionBuilder)new SamlTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new KerberosTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new SecureConversationTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new BootstrapPolicyBuilder());
        reg.registerBuilder((AssertionBuilder)new SecurityContextTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new SignedElementsBuilder());
        reg.registerBuilder((AssertionBuilder)new SignedPartsBuilder());
        reg.registerBuilder((AssertionBuilder)new SignatureTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new SpnegoContextTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new SupportingTokensBuilder());
        reg.registerBuilder((AssertionBuilder)new SymmetricBindingBuilder());
        reg.registerBuilder((AssertionBuilder)new TransportBindingBuilder());
        reg.registerBuilder((AssertionBuilder)new TransportTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new Trust10Builder());
        reg.registerBuilder((AssertionBuilder)new Trust13Builder());
        reg.registerBuilder((AssertionBuilder)new UsernameTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new KeyValueTokenBuilder());
        reg.registerBuilder((AssertionBuilder)new WSS10Builder());
        reg.registerBuilder((AssertionBuilder)new WSS11Builder());
        reg.registerBuilder((AssertionBuilder)new X509TokenBuilder());
        List<QName> others = Arrays.asList(SP12Constants.INCLUDE_TIMESTAMP, SP11Constants.INCLUDE_TIMESTAMP, SP12Constants.ENCRYPT_SIGNATURE, SP11Constants.ENCRYPT_SIGNATURE, SP12Constants.PROTECT_TOKENS, SP11Constants.PROTECT_TOKENS, SP12Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY, SP11Constants.ONLY_SIGN_ENTIRE_HEADERS_AND_BODY, SP12Constants.WSS_X509_V1_TOKEN_10, SP12Constants.WSS_X509_V1_TOKEN_11, SP12Constants.WSS_X509_V3_TOKEN_10, SP12Constants.WSS_X509_V3_TOKEN_11, SP11Constants.WSS_X509_V1_TOKEN_10, SP11Constants.WSS_X509_V1_TOKEN_11, SP11Constants.WSS_X509_V3_TOKEN_10, SP11Constants.WSS_X509_V3_TOKEN_11, SP12Constants.WSS_X509_PKCS7_TOKEN_11, SP12Constants.WSS_X509_PKI_PATH_V1_TOKEN_11, SP11Constants.WSS_X509_PKCS7_TOKEN_11, SP11Constants.WSS_X509_PKI_PATH_V1_TOKEN_11, SP12Constants.REQUIRE_THUMBPRINT_REFERENCE, SP11Constants.REQUIRE_THUMBPRINT_REFERENCE, SP12Constants.REQUIRE_DERIVED_KEYS, SP11Constants.REQUIRE_DERIVED_KEYS, SP12Constants.REQUIRE_INTERNAL_REFERENCE, SP11Constants.REQUIRE_INTERNAL_REFERENCE, SP12Constants.REQUIRE_ISSUER_SERIAL_REFERENCE, SP11Constants.REQUIRE_ISSUER_SERIAL_REFERENCE, SP12Constants.REQUIRE_EMBEDDED_TOKEN_REFERENCE, SP11Constants.REQUIRE_EMBEDDED_TOKEN_REFERENCE, SP12Constants.ENCRYPT_BEFORE_SIGNING, SP11Constants.ENCRYPT_BEFORE_SIGNING, SP12Constants.SIGN_BEFORE_ENCRYPTING, SP11Constants.SIGN_BEFORE_ENCRYPTING, SP12Constants.REQUIRE_KEY_IDENTIFIER_REFERENCE, SP11Constants.REQUIRE_KEY_IDENTIFIER_REFERENCE, SP12Constants.PROTECT_TOKENS, SP11Constants.PROTECT_TOKENS, SP12Constants.RSA_KEY_VALUE, SP11Constants.LAX, SP11Constants.LAXTSFIRST, SP11Constants.LAXTSLAST, SP11Constants.STRICT, SP12Constants.LAX, SP12Constants.LAXTSFIRST, SP12Constants.LAXTSLAST, SP12Constants.STRICT, SP11Constants.WSS_USERNAME_TOKEN10, SP12Constants.WSS_USERNAME_TOKEN10, SP11Constants.WSS_USERNAME_TOKEN11, SP12Constants.WSS_USERNAME_TOKEN11, SP12Constants.HASH_PASSWORD, SP12Constants.NO_PASSWORD, SP13Constants.CREATED, SP13Constants.NONCE, SP12Constants.REQUIRE_INTERNAL_REFERENCE, SP11Constants.REQUIRE_INTERNAL_REFERENCE, SP12Constants.REQUIRE_EXTERNAL_REFERNCE, SP11Constants.REQUIRE_EXTERNAL_REFERNCE, new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssKerberosV5ApReqToken11"), new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssKerberosV5ApReqToken11"), new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssGssKerberosV5ApReqToken11"), new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssGssKerberosV5ApReqToken11"), SP12Constants.MUST_NOT_SEND_AMEND, SP12Constants.MUST_NOT_SEND_CANCEL, SP12Constants.MUST_NOT_SEND_RENEW, new QName("http://schemas.microsoft.com/ws/2005/07/securitypolicy", "MustNotSendCancel"), SP12Constants.REQUIRE_EXTERNAL_URI_REFERENCE, SP12Constants.SC13_SECURITY_CONTEXT_TOKEN, SP11Constants.SC10_SECURITY_CONTEXT_TOKEN, SP12Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER, SP11Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER, SP12Constants.MUST_SUPPORT_REF_ISSUER_SERIAL, SP11Constants.MUST_SUPPORT_REF_ISSUER_SERIAL, SP12Constants.MUST_SUPPORT_REF_EXTERNAL_URI, SP12Constants.MUST_SUPPORT_REF_EXTERNAL_URI, SP12Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN, SP11Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN, SP12Constants.MUST_SUPPORT_REF_THUMBPRINT, SP11Constants.MUST_SUPPORT_REF_THUMBPRINT, SP12Constants.MUST_SUPPORT_REF_ENCRYPTED_KEY, SP11Constants.MUST_SUPPORT_REF_ENCRYPTED_KEY, SP12Constants.REQUIRE_SIGNATURE_CONFIRMATION, SP11Constants.REQUIRE_SIGNATURE_CONFIRMATION, new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV11Token10"), new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssSamlV11Token10"), new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV11Token11"), new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssSamlV11Token11"), new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "WssSamlV20Token11"), new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", "WssSamlV20Token11"), SP12Constants.HTTP_BASIC_AUTHENTICATION, SP12Constants.HTTP_DIGEST_AUTHENTICATION, SP12Constants.REQUIRE_CLIENT_CERTIFICATE, SP12Constants.MUST_SUPPORT_CLIENT_CHALLENGE, SP11Constants.MUST_SUPPORT_CLIENT_CHALLENGE, SP12Constants.MUST_SUPPORT_SERVER_CHALLENGE, SP11Constants.MUST_SUPPORT_SERVER_CHALLENGE, SP12Constants.REQUIRE_CLIENT_ENTROPY, SP11Constants.REQUIRE_CLIENT_ENTROPY, SP12Constants.REQUIRE_SERVER_ENTROPY, SP11Constants.REQUIRE_SERVER_ENTROPY, SP12Constants.MUST_SUPPORT_ISSUED_TOKENS, SP11Constants.MUST_SUPPORT_ISSUED_TOKENS, SP12Constants.REQUIRE_REQUEST_SECURITY_TOKEN_COLLECTION, SP12Constants.REQUIRE_APPLIES_TO, SP13Constants.SCOPE_POLICY_15, SP13Constants.MUST_SUPPORT_INTERACTIVE_CHALLENGE);
        final HashMap<QName, PrimitiveAssertion> assertions = new HashMap<QName, PrimitiveAssertion>();
        for (QName q : others) {
            assertions.put(q, new PrimitiveAssertion(q));
        }
        for (String s : AlgorithmSuite.getSupportedAlgorithmSuiteNames()) {
            QName q = new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", s);
            assertions.put(q, new PrimitiveAssertion(q));
            q = new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", s);
            assertions.put(q, new PrimitiveAssertion(q));
        }
        reg.registerBuilder((AssertionBuilder)new PrimitiveAssertionBuilder(assertions.keySet()){

            public Assertion build(Element element, AssertionBuilderFactory fact) {
                if (XMLPrimitiveAssertionBuilder.isOptional((Element)element) || XMLPrimitiveAssertionBuilder.isIgnorable((Element)element)) {
                    return super.build(element, fact);
                }
                QName q = new QName(element.getNamespaceURI(), element.getLocalName());
                return (Assertion)assertions.get(q);
            }
        });
    }

    public void registerProviders() {
        PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        if (reg == null) {
            return;
        }
        reg.register((PolicyInterceptorProvider)new WSSecurityPolicyInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new WSSecurityInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new HttpsTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new KerberosTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new IssuedTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new UsernameTokenInterceptorProvider(this.bus));
        reg.register((PolicyInterceptorProvider)new SamlTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new SecureConversationTokenInterceptorProvider());
        reg.register((PolicyInterceptorProvider)new SpnegoTokenInterceptorProvider());
    }
}

