/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.grammar;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.grammar.IStates;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger(AbstractGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    protected GrammarTransition[][] transitions;
    protected String name;
    protected IStates statesEnum;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GrammarTransition getTransition(int state, int tag) {
        return this.transitions[state][tag & 0xFF];
    }

    public void executeAction(IAsn1Container container) throws DecoderException {
        int currentState = container.getTransition();
        IGrammar currentGrammar = container.getGrammar();
        if (currentState == -1) {
            return;
        }
        byte tagByte = container.getCurrentTLV().getTag();
        GrammarTransition transition = ((AbstractGrammar)container.getGrammar()).getTransition(currentState, tagByte);
        if (transition == null) {
            String errorMessage = I18n.err((String)"ERR_00001", (Object[])new Object[]{currentGrammar.getStatesEnum().getState(currentState), Asn1StringUtils.dumpByte(tagByte)});
            log.error(errorMessage);
            throw new DecoderException(I18n.err((String)"ERR_00002", (Object[])new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug(transition.toString(currentGrammar.getStatesEnum()));
        }
        if (transition.hasAction()) {
            transition.getAction().action(container);
        }
        container.setTransition(transition.getCurrentState());
    }

    public IStates getStatesEnum() {
        return this.statesEnum;
    }

    public void setStatesEnum(IStates statesEnum) {
        this.statesEnum = statesEnum;
    }
}

