/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.dolphinscheduler.common.utils.HttpUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosHttpClient {
    public static final Logger logger = LoggerFactory.getLogger(KerberosHttpClient.class);
    private String principal;
    private String keyTabLocation;

    public KerberosHttpClient(String principal, String keyTabLocation) {
        this.principal = principal;
        this.keyTabLocation = keyTabLocation;
    }

    public KerberosHttpClient(String principal, String keyTabLocation, boolean isDebug) {
        this(principal, keyTabLocation);
        if (isDebug) {
            System.setProperty("sun.security.spnego.debug", "true");
            System.setProperty("sun.security.krb5.debug", "true");
        }
    }

    public KerberosHttpClient(String principal, String keyTabLocation, String krb5Location, boolean isDebug) {
        this(principal, keyTabLocation, isDebug);
        System.setProperty("java.security.krb5.conf", krb5Location);
    }

    private static CloseableHttpClient buildSpengoHttpClient() {
        HttpClientBuilder builder = HttpUtils.getHttpClientBuilder();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return builder.build();
    }

    public String get(String url, String userId) {
        logger.info("Calling KerberosHttpClient {} {} {}", new Object[]{this.principal, this.keyTabLocation, url});
        Configuration config = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>(9);
                options.put("useTicketCache", "false");
                options.put("useKeyTab", "true");
                options.put("keyTab", KerberosHttpClient.this.keyTabLocation);
                options.put("refreshKrb5Config", "true");
                options.put("principal", KerberosHttpClient.this.principal);
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("isInitiator", "true");
                options.put("debug", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        princ.add(new KerberosPrincipal(userId));
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        try {
            LoginContext lc = new LoginContext("", sub, null, config);
            lc.login();
            Subject serviceSubject = lc.getSubject();
            return Subject.doAs(serviceSubject, () -> {
                CloseableHttpClient httpClient = KerberosHttpClient.buildSpengoHttpClient();
                HttpGet httpget = new HttpGet(url);
                return HttpUtils.getResponseContentString(httpget, httpClient);
            });
        }
        catch (LoginException le) {
            logger.error("Kerberos authentication failed ", (Throwable)le);
            return null;
        }
    }

    public static String get(String url) {
        KerberosHttpClient kerberosHttpClient = new KerberosHttpClient(PropertyUtils.getString("login.user.keytab.username"), PropertyUtils.getString("login.user.keytab.path"), PropertyUtils.getString("java.security.krb5.conf.path"), true);
        String responseContent = kerberosHttpClient.get(url, PropertyUtils.getString("login.user.keytab.username"));
        return responseContent;
    }
}

