/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    public static final Logger logger = LoggerFactory.getLogger(ScriptRunner.class);
    private static final String DEFAULT_DELIMITER = ";";
    private final Connection connection;
    private final boolean stopOnError;
    private final boolean autoCommit;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public ScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException | SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    logger.info(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//")) continue;
                if (trimmedLine.startsWith("delimiter")) {
                    String newDelimiter = trimmedLine.split(" ")[1];
                    this.setDelimiter(newDelimiter, this.fullLineDelimiter);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line, 0, line.lastIndexOf(this.getDelimiter()));
                    command.append(" ");
                    logger.info("sql: {}", (Object)command);
                    try (Statement statement = conn.createStatement();){
                        statement.execute(command.toString());
                        try (ResultSet rs = statement.getResultSet();){
                            if (this.stopOnError && rs != null) {
                                int i;
                                ResultSetMetaData md = rs.getMetaData();
                                int cols = md.getColumnCount();
                                for (i = 1; i < cols; ++i) {
                                    String name = md.getColumnLabel(i);
                                    logger.info("{} \t", (Object)name);
                                }
                                logger.info("");
                                while (rs.next()) {
                                    for (i = 1; i < cols; ++i) {
                                        String value = rs.getString(i);
                                        logger.info("{} \t", (Object)value);
                                    }
                                    logger.info("");
                                }
                            }
                        }
                    }
                    catch (SQLException e) {
                        logger.error("SQLException", (Throwable)e);
                        throw e;
                    }
                    command = null;
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (SQLException e) {
            logger.error("Error executing: {}", command);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            logger.error("Error executing: {}", command);
            throw e;
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }
}

