/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums.dp;

import java.util.HashMap;
import java.util.Map;

public enum DqFailureStrategy {
    ALERT(0, "alert"),
    BLOCK(1, "block");

    private final int code;
    private final String description;
    private static final Map<Integer, DqFailureStrategy> VALUES_MAP;

    private DqFailureStrategy(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static DqFailureStrategy of(Integer status) {
        if (VALUES_MAP.containsKey(status)) {
            return VALUES_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid code : " + status);
    }

    static {
        VALUES_MAP = new HashMap<Integer, DqFailureStrategy>();
        for (DqFailureStrategy type : DqFailureStrategy.values()) {
            VALUES_MAP.put(type.code, type);
        }
    }
}

