/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.loop;

import java.time.Duration;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.dolphinscheduler.plugin.task.api.AbstractRemoteTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskConstants;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceInfo;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.ApplicationInfo;
import org.apache.dolphinscheduler.plugin.task.api.utils.RetryUtils;

public abstract class BaseLoopTaskExecutor
extends AbstractRemoteTask {
    protected volatile boolean cancel = false;
    @Nullable
    protected LoopTaskInstanceInfo loopTaskInstanceInfo;

    protected BaseLoopTaskExecutor(@NonNull TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        if (taskExecutionContext == null) {
            throw new NullPointerException("taskExecutionContext is marked non-null but is null");
        }
    }

    @Override
    public void handle(TaskCallBack taskCallBack) throws TaskException {
        try {
            long loopInterval = this.getTaskInstanceStatusQueryInterval().toMillis();
            this.loopTaskInstanceInfo = this.submitLoopTask();
            this.setAppIds(this.loopTaskInstanceInfo.getTaskInstanceId());
            taskCallBack.updateRemoteApplicationInfo(this.taskRequest.getTaskInstanceId(), new ApplicationInfo(this.getAppIds()));
            LoopTaskInstanceStatus loopTaskInstanceStatus = null;
            while (!this.cancel && !(loopTaskInstanceStatus = RetryUtils.retryFunction(() -> this.queryTaskInstanceStatus(this.loopTaskInstanceInfo))).isFinished()) {
                Thread.sleep(loopInterval);
            }
            if (loopTaskInstanceStatus != null && loopTaskInstanceStatus.isSuccess()) {
                this.setExitStatusCode(0);
                this.logger.info("The task instance: {} execute successfully.", (Object)this.appIds);
            } else {
                this.setExitStatusCode(-1);
                this.logger.info("The task instance: {} is execute failure.", (Object)this.appIds);
            }
        }
        catch (InterruptedException e) {
            this.setExitStatusCode(-1);
            this.logger.error("The current loop thread has been interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new TaskException("The current loop thread has been interrupted");
        }
        catch (TaskException ex) {
            this.logger.error("Loop task execute error", (Throwable)ex);
            this.setExitStatusCode(-1);
            throw ex;
        }
        catch (Exception ex) {
            this.setExitStatusCode(-1);
            this.logger.error("Loop task execute error", (Throwable)ex);
            throw new TaskException("Loop task execute error", ex);
        }
    }

    @NonNull
    public abstract LoopTaskInstanceInfo submitLoopTask() throws TaskException;

    @NonNull
    public abstract LoopTaskInstanceStatus queryTaskInstanceStatus(@NonNull LoopTaskInstanceInfo var1) throws TaskException;

    @NonNull
    public Duration getTaskInstanceStatusQueryInterval() {
        return TaskConstants.DEFAULT_LOOP_STATUS_INTERVAL;
    }

    public abstract void cancelLoopTaskInstance(@Nullable LoopTaskInstanceInfo var1) throws TaskException;

    @Override
    public void cancelApplication() throws TaskException {
        this.cancel = true;
        this.cancelLoopTaskInstance(this.loopTaskInstanceInfo);
    }
}

