/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.loop.template.http.method;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskCancelMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.loop.LoopTaskInstanceInfo;
import org.apache.dolphinscheduler.plugin.task.api.loop.template.http.HttpLoopTaskMethodDefinition;
import org.apache.dolphinscheduler.plugin.task.api.utils.OkHttpUtils;

public class HttpLoopTaskCancelTaskMethodDefinition
extends HttpLoopTaskMethodDefinition
implements LoopTaskCancelMethodDefinition {
    private final String taskInstanceIdHolder = "${taskInstanceId}";

    public HttpLoopTaskCancelTaskMethodDefinition(String url, String httpMethodType, String dataType, Map<String, String> httpHeaders, Map<String, Object> requestParams, Map<String, Object> requestBody) {
        super(url, httpMethodType, dataType, httpHeaders, requestParams, requestBody);
    }

    @Override
    public void cancelTaskInstance(@Nullable LoopTaskInstanceInfo loopTaskInstanceInfo) {
        block10: {
            if (loopTaskInstanceInfo == null) {
                return;
            }
            if (this.requestParams != null) {
                for (Map.Entry entry : this.requestParams.entrySet()) {
                    if (!StringUtils.equals((CharSequence)entry.getValue().toString(), (CharSequence)"${taskInstanceId}")) continue;
                    entry.setValue(loopTaskInstanceInfo.getTaskInstanceId());
                }
            }
            if (this.requestBody != null) {
                for (Map.Entry entry : this.requestBody.entrySet()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)entry.getValue().toString(), (CharSequence)"${taskInstanceId}")) continue;
                    entry.setValue(loopTaskInstanceInfo.getTaskInstanceId());
                }
            }
            try {
                if (StringUtils.equalsIgnoreCase((CharSequence)"get", (CharSequence)this.httpMethodType)) {
                    OkHttpUtils.get(this.url, this.httpHeaders, this.requestParams);
                    break block10;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"post", (CharSequence)this.httpMethodType)) {
                    OkHttpUtils.post(this.url, this.httpHeaders, this.requestParams, this.requestBody);
                    break block10;
                }
                throw new IllegalArgumentException(String.format("http method type: %s is not supported", this.httpMethodType));
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Query loop task instance status failed", ex);
            }
        }
    }
}

