/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.parser;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parser.PlaceholderUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.TimePlaceholderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParameterUtils.class);
    private static final String DATE_PARSE_PATTERN = "\\$\\[([^\\$\\]]+)]";
    private static final String DATE_START_PATTERN = "^[0-9]";
    private static final char PARAM_REPLACE_CHAR = '?';

    private ParameterUtils() {
        throw new UnsupportedOperationException("Construct ParameterUtils");
    }

    public static String convertParameterPlaceholders(String parameterString, Map<String, String> parameterMap) {
        java.util.Date cronTime;
        if (StringUtils.isEmpty((CharSequence)parameterString)) {
            return parameterString;
        }
        if (parameterMap != null && !parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        }
        if (parameterMap != null && null != parameterMap.get("system.datetime")) {
            String cronTimeStr = parameterMap.get("system.datetime");
            cronTime = DateUtils.parse((String)cronTimeStr, (String)"yyyyMMddHHmmss");
        } else {
            cronTime = new java.util.Date();
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static String convertParameterPlaceholders2(String parameterString, Map<String, String> parameterMap) {
        if (StringUtils.isEmpty((CharSequence)parameterString)) {
            return parameterString;
        }
        String cronTimeStr = parameterMap.get("schedule.time");
        java.util.Date cronTime = null;
        cronTime = StringUtils.isNotEmpty((CharSequence)cronTimeStr) ? DateUtils.parse((String)cronTimeStr, (String)"yyyyMMddHHmmss") : new java.util.Date();
        if (!parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static void setInParameter(int index, PreparedStatement stmt, DataType dataType, String value) throws Exception {
        if (dataType.equals((Object)DataType.VARCHAR)) {
            stmt.setString(index, value);
        } else if (dataType.equals((Object)DataType.INTEGER)) {
            stmt.setInt(index, Integer.parseInt(value));
        } else if (dataType.equals((Object)DataType.LONG)) {
            stmt.setLong(index, Long.parseLong(value));
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            stmt.setFloat(index, Float.parseFloat(value));
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            stmt.setDouble(index, Double.parseDouble(value));
        } else if (dataType.equals((Object)DataType.DATE)) {
            stmt.setDate(index, Date.valueOf(value));
        } else if (dataType.equals((Object)DataType.TIME)) {
            stmt.setString(index, value);
        } else if (dataType.equals((Object)DataType.TIMESTAMP)) {
            stmt.setTimestamp(index, Timestamp.valueOf(value));
        } else if (dataType.equals((Object)DataType.BOOLEAN)) {
            stmt.setBoolean(index, Boolean.parseBoolean(value));
        }
    }

    public static String expandListParameter(Map<Integer, Property> params, String sql) {
        HashMap<Integer, Property> expandMap = new HashMap<Integer, Property>();
        if (params == null || params.isEmpty()) {
            return sql;
        }
        String[] split = sql.split("\\?");
        if (split.length == 0) {
            return sql;
        }
        StringBuilder ret = new StringBuilder(split[0]);
        int index = 1;
        for (int i = 1; i < split.length; ++i) {
            Property property = params.get(i);
            String value = property.getValue();
            if (DataType.LIST.equals((Object)property.getType())) {
                List valueList = JSONUtils.toList((String)value, Object.class);
                if (valueList.isEmpty() && StringUtils.isNotBlank((CharSequence)value)) {
                    valueList.add(value);
                }
                for (int j = 0; j < valueList.size(); ++j) {
                    ret.append('?');
                    if (j == valueList.size() - 1) continue;
                    ret.append(",");
                }
                for (Object v : valueList) {
                    Property newProperty = new Property();
                    if (v instanceof Integer) {
                        newProperty.setType(DataType.INTEGER);
                    } else if (v instanceof Long) {
                        newProperty.setType(DataType.LONG);
                    } else if (v instanceof Float) {
                        newProperty.setType(DataType.FLOAT);
                    } else if (v instanceof Double) {
                        newProperty.setType(DataType.DOUBLE);
                    } else {
                        newProperty.setType(DataType.VARCHAR);
                    }
                    newProperty.setValue(v.toString());
                    newProperty.setProp(property.getProp());
                    newProperty.setDirect(property.getDirect());
                    expandMap.put(index++, newProperty);
                }
            } else {
                ret.append('?');
                expandMap.put(index++, property);
            }
            ret.append(split[i]);
        }
        if ('?' == sql.charAt(sql.length() - 1)) {
            ret.append('?');
            expandMap.put(index, params.get(split.length));
        }
        params.clear();
        params.putAll(expandMap);
        return ret.toString();
    }

    public static String replaceScheduleTime(String text, java.util.Date scheduleTime) {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (null == scheduleTime) {
            scheduleTime = new java.util.Date();
        }
        String dateTime = DateUtils.format((java.util.Date)scheduleTime, (String)"yyyyMMddHHmmss");
        Property p = new Property();
        p.setValue(dateTime);
        p.setProp("schedule.time");
        paramsMap.put("schedule.time", p);
        text = ParameterUtils.convertParameterPlaceholders2(text, ParameterUtils.convert(paramsMap));
        return text;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    private static String dateTemplateParse(String templateStr, java.util.Date date) {
        if (templateStr == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(DATE_PARSE_PATTERN);
        StringBuffer newValue = new StringBuffer(templateStr.length());
        Matcher matcher = pattern.matcher(templateStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (Pattern.matches(DATE_START_PATTERN, key)) continue;
            String value = TimePlaceholderUtils.getPlaceHolderTime(key, date);
            assert (value != null);
            matcher.appendReplacement(newValue, value);
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }
}

