/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class LogUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    private static final Pattern APPLICATION_REGEX = Pattern.compile("application_\\d+_\\d+");

    public static List<String> getAppIdsFromLogFile(@NonNull String logPath) {
        if (logPath == null) {
            throw new NullPointerException("logPath is marked non-null but is null");
        }
        return LogUtils.getAppIdsFromLogFile(logPath, log);
    }

    public static List<String> getAppIdsFromLogFile(@NonNull String logPath, Logger logger) {
        ArrayList<String> arrayList;
        block10: {
            if (logPath == null) {
                throw new NullPointerException("logPath is marked non-null but is null");
            }
            File logFile = new File(logPath);
            if (!logFile.exists() || !logFile.isFile()) {
                return Collections.emptyList();
            }
            HashSet appIds = new HashSet();
            Stream<String> stream = Files.lines(Paths.get(logPath, new String[0]));
            try {
                stream.filter(line -> {
                    Matcher matcher = APPLICATION_REGEX.matcher((CharSequence)line);
                    return matcher.find();
                }).forEach(line -> {
                    String appId;
                    Matcher matcher = APPLICATION_REGEX.matcher((CharSequence)line);
                    if (matcher.find() && appIds.add(appId = matcher.group())) {
                        logger.info("Find appId: {} from {}", (Object)appId, (Object)logPath);
                    }
                });
                arrayList = new ArrayList<String>(appIds);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Get appId from log file erro, logPath: {}", (Object)logPath, (Object)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return arrayList;
    }

    public static String readWholeFileContent(String filePath) {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("read file error", (Throwable)e);
                return "";
            }
        }
        br.close();
        return string;
    }

    public static void setWorkflowAndTaskInstanceIDMDC(Integer workflowInstanceId, Integer taskInstanceId) {
        LogUtils.setWorkflowInstanceIdMDC(workflowInstanceId);
        LogUtils.setTaskInstanceIdMDC(taskInstanceId);
    }

    public static void setWorkflowInstanceIdMDC(Integer workflowInstanceId) {
        MDC.put((String)"workflowInstanceId", (String)String.valueOf(workflowInstanceId));
    }

    public static void setTaskInstanceIdMDC(Integer taskInstanceId) {
        MDC.put((String)"taskInstanceId", (String)String.valueOf(taskInstanceId));
    }

    public static void removeWorkflowAndTaskInstanceIdMDC() {
        LogUtils.removeWorkflowInstanceIdMDC();
        LogUtils.removeTaskInstanceIdMDC();
    }

    public static void removeWorkflowInstanceIdMDC() {
        MDC.remove((String)"workflowInstanceId");
    }

    public static void removeTaskInstanceIdMDC() {
        MDC.remove((String)"taskInstanceId");
    }

    @Generated
    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

