/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.flink;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.stream.StreamTask;
import org.apache.dolphinscheduler.plugin.task.flink.FileUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkArgsUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkStreamParameters;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkTask;

public class FlinkStreamTask
extends FlinkTask
implements StreamTask {
    private FlinkStreamParameters flinkParameters;
    private TaskExecutionContext taskExecutionContext;

    public FlinkStreamTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("flink task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.flinkParameters = (FlinkStreamParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), FlinkStreamParameters.class));
        if (this.flinkParameters == null || !this.flinkParameters.checkParameters()) {
            throw new RuntimeException("flink task params is not valid");
        }
        this.flinkParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        FileUtils.generateScriptFile((TaskExecutionContext)this.taskExecutionContext, (FlinkParameters)this.flinkParameters);
    }

    protected String buildCommand() {
        List args = FlinkArgsUtils.buildRunCommandLine((TaskExecutionContext)this.taskExecutionContext, (FlinkParameters)this.flinkParameters);
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)this.taskExecutionContext.getDefinedParams());
        this.logger.info("flink task command : {}", (Object)command);
        return command;
    }

    protected void setMainJarName() {
        ResourceInfo mainJar = this.flinkParameters.getMainJar();
        String resourceName = this.getResourceNameOfMainJar(mainJar);
        mainJar.setRes(resourceName);
        this.flinkParameters.setMainJar(mainJar);
    }

    public AbstractParameters getParameters() {
        return this.flinkParameters;
    }

    public void cancelApplication() throws TaskException {
        List appIds = this.getApplicationIds();
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            this.logger.error("can not get appId, taskInstanceId:{}", (Object)this.taskExecutionContext.getTaskInstanceId());
            return;
        }
        this.taskExecutionContext.setAppIds(String.join((CharSequence)",", appIds));
        List args = FlinkArgsUtils.buildCancelCommandLine((TaskExecutionContext)this.taskExecutionContext);
        this.logger.info("cancel application args:{}", (Object)args);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(args);
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            throw new TaskException("cancel application error", (Throwable)e);
        }
    }

    public void savePoint() throws Exception {
        List appIds = this.getApplicationIds();
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            this.logger.warn("can not get appId, taskInstanceId:{}", (Object)this.taskExecutionContext.getTaskInstanceId());
            return;
        }
        this.taskExecutionContext.setAppIds(String.join((CharSequence)",", appIds));
        List args = FlinkArgsUtils.buildSavePointCommandLine((TaskExecutionContext)this.taskExecutionContext);
        this.logger.info("savepoint args:{}", (Object)args);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(args);
        processBuilder.start();
    }
}

