/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.wrapper;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.interceptor.ClusterInterceptor;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public abstract class AbstractCluster
implements Cluster {
    private <T> Invoker<T> buildClusterInterceptors(AbstractClusterInvoker<T> clusterInvoker, String key) {
        AbstractClusterInvoker<T> last = clusterInvoker;
        List interceptors = ExtensionLoader.getExtensionLoader(ClusterInterceptor.class).getActivateExtension(clusterInvoker.getUrl(), key);
        if (!interceptors.isEmpty()) {
            for (int i = interceptors.size() - 1; i >= 0; --i) {
                ClusterInterceptor interceptor = (ClusterInterceptor)interceptors.get(i);
                AbstractClusterInvoker<T> next = last;
                last = new InterceptorInvokerNode<T>(clusterInvoker, interceptor, next);
            }
        }
        return last;
    }

    @Override
    public <T> Invoker<T> join(Directory<T> directory) throws RpcException {
        return this.buildClusterInterceptors(this.doJoin(directory), directory.getUrl().getParameter("reference.interceptor"));
    }

    protected abstract <T> AbstractClusterInvoker<T> doJoin(Directory<T> var1) throws RpcException;

    protected class InterceptorInvokerNode<T>
    extends AbstractClusterInvoker<T> {
        private AbstractClusterInvoker<T> clusterInvoker;
        private ClusterInterceptor interceptor;
        private AbstractClusterInvoker<T> next;

        public InterceptorInvokerNode(AbstractClusterInvoker<T> clusterInvoker, ClusterInterceptor interceptor, AbstractClusterInvoker<T> next) {
            this.clusterInvoker = clusterInvoker;
            this.interceptor = interceptor;
            this.next = next;
        }

        @Override
        public Class<T> getInterface() {
            return this.clusterInvoker.getInterface();
        }

        @Override
        public URL getUrl() {
            return this.clusterInvoker.getUrl();
        }

        @Override
        public boolean isAvailable() {
            return this.clusterInvoker.isAvailable();
        }

        @Override
        public Result invoke(Invocation invocation) throws RpcException {
            Result asyncResult;
            try {
                this.interceptor.before(this.next, invocation);
                asyncResult = this.interceptor.intercept(this.next, invocation);
            }
            catch (Exception e) {
                if (this.interceptor instanceof ClusterInterceptor.Listener) {
                    ClusterInterceptor.Listener listener = (ClusterInterceptor.Listener)((Object)this.interceptor);
                    listener.onError(e, this.clusterInvoker, invocation);
                }
                throw e;
            }
            finally {
                this.interceptor.after(this.next, invocation);
            }
            return asyncResult.whenCompleteWithContext((r, t) -> {
                if (this.interceptor instanceof ClusterInterceptor.Listener) {
                    ClusterInterceptor.Listener listener = (ClusterInterceptor.Listener)((Object)this.interceptor);
                    if (t == null) {
                        listener.onMessage((Result)r, this.clusterInvoker, invocation);
                    } else {
                        listener.onError((Throwable)t, this.clusterInvoker, invocation);
                    }
                }
            });
        }

        @Override
        public void destroy() {
            this.clusterInvoker.destroy();
        }

        @Override
        public String toString() {
            return this.clusterInvoker.toString();
        }

        @Override
        protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
            return null;
        }
    }
}

