/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.merger;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.cluster.Merger;
import org.apache.dubbo.rpc.cluster.merger.ArrayMerger;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class MergerFactory
implements ScopeModelAware {
    private ConcurrentMap<Class<?>, Merger<?>> MERGER_CACHE = new ConcurrentHashMap();
    private ScopeModel scopeModel;

    public void setScopeModel(ScopeModel scopeModel) {
        this.scopeModel = scopeModel;
    }

    public <T> Merger<T> getMerger(Class<T> returnType) {
        Merger result;
        if (returnType == null) {
            throw new IllegalArgumentException("returnType is null");
        }
        if (returnType.isArray()) {
            Class<?> type = returnType.getComponentType();
            result = (Merger)this.MERGER_CACHE.get(type);
            if (result == null) {
                this.loadMergers();
                result = (Merger)this.MERGER_CACHE.get(type);
            }
            if (result == null && !type.isPrimitive()) {
                result = ArrayMerger.INSTANCE;
            }
        } else {
            result = (Merger)this.MERGER_CACHE.get(returnType);
            if (result == null) {
                this.loadMergers();
                result = (Merger)this.MERGER_CACHE.get(returnType);
            }
        }
        return result;
    }

    private void loadMergers() {
        Set names = this.scopeModel.getExtensionLoader(Merger.class).getSupportedExtensions();
        for (String name : names) {
            Merger m = (Merger)this.scopeModel.getExtensionLoader(Merger.class).getExtension(name);
            this.MERGER_CACHE.putIfAbsent(ReflectUtils.getGenericClass(m.getClass()), m);
        }
    }
}

