/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.Node;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invoker;

public class RouterSnapshotNode<T> {
    private final String name;
    private final int beforeSize;
    private int afterSize;
    private String routerMessage;
    private List<Invoker<T>> outputInvokers;
    private RouterSnapshotNode<T> nextNode;

    public RouterSnapshotNode(String name, int beforeSize) {
        this.name = name;
        this.beforeSize = beforeSize;
    }

    public String getName() {
        return this.name;
    }

    public int getBeforeSize() {
        return this.beforeSize;
    }

    public int getAfterSize() {
        return this.afterSize;
    }

    public String getRouterMessage() {
        return this.routerMessage;
    }

    public void setRouterMessage(String routerMessage) {
        this.routerMessage = routerMessage;
    }

    public List<Invoker<T>> getOutputInvokers() {
        return this.outputInvokers;
    }

    public void setOutputInvokers(List<Invoker<T>> outputInvokers) {
        this.outputInvokers = outputInvokers;
        this.afterSize = outputInvokers == null ? 0 : outputInvokers.size();
    }

    public RouterSnapshotNode<T> getNextNode() {
        return this.nextNode;
    }

    public void appendNode(RouterSnapshotNode<T> nextNode) {
        if (this.nextNode != null) {
            RouterSnapshotNode<T> node = this.nextNode;
            while (node.nextNode != null) {
                node = node.nextNode;
            }
            node.nextNode = nextNode;
        } else {
            this.nextNode = nextNode;
        }
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int level) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ").append(this.name).append(" ").append("invokers: ").append(this.beforeSize).append(" -> ").append(this.afterSize).append(" ").append(this.routerMessage == null ? "" : this.routerMessage).append("] ").append(this.outputInvokers == null ? "" : this.outputInvokers.subList(0, Math.min(5, this.outputInvokers.size())).stream().map(Node::getUrl).map(URL::getAddress).collect(Collectors.joining(",")));
        if (this.outputInvokers != null && this.outputInvokers.size() > 5) {
            stringBuilder.append("...");
        }
        if (this.nextNode != null) {
            stringBuilder.append("\n");
            for (int i = 0; i < level; ++i) {
                stringBuilder.append("  ");
            }
            stringBuilder.append(this.nextNode.toString(level + 1));
        }
        return stringBuilder.toString();
    }
}

