/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.matcher.pattern.range;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.pattern.ValuePattern;

@Activate(order=100)
public class RangeValuePattern
implements ValuePattern {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RangeValuePattern.class);

    @Override
    public boolean shouldMatch(String pattern) {
        return pattern.contains("~");
    }

    @Override
    public boolean match(String pattern, String value, URL url, Invocation invocation, boolean isWhenCondition) {
        boolean defaultValue = !isWhenCondition;
        try {
            int intValue = StringUtils.parseInteger((String)value);
            String[] arr = pattern.split("~");
            if (arr.length < 2) {
                logger.error("2-7", "", "", "Invalid condition rule " + pattern + " or value " + value + ", will ignore.");
                return defaultValue;
            }
            String rawStart = arr[0];
            String rawEnd = arr[1];
            if (StringUtils.isEmpty((String)rawStart) && StringUtils.isEmpty((String)rawEnd)) {
                return defaultValue;
            }
            if (StringUtils.isEmpty((String)rawStart)) {
                int end = StringUtils.parseInteger((String)rawEnd);
                if (intValue > end) {
                    return false;
                }
            } else if (StringUtils.isEmpty((String)rawEnd)) {
                int start = StringUtils.parseInteger((String)rawStart);
                if (intValue < start) {
                    return false;
                }
            } else {
                int start = StringUtils.parseInteger((String)rawStart);
                int end = StringUtils.parseInteger((String)rawEnd);
                if (intValue < start || intValue > end) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.error("2-7", "Parse integer error", "", "Invalid condition rule " + pattern + " or value " + value + ", will ignore.", (Throwable)e);
            return defaultValue;
        }
        return true;
    }
}

