/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.ConditionSubSet;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.DestinationSet;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.MultiDestCondition;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.ConditionMatcher;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.ConditionMatcherFactory;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class MultiDestConditionRouter<T>
extends AbstractStateRouter<T> {
    public static final String NAME = "multi_condition";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractStateRouter.class);
    protected static final Pattern ROUTE_PATTERN = Pattern.compile("([&!=,]*)\\s*([^&!=,\\s]+)");
    private Map<String, ConditionMatcher> whenCondition;
    private List<ConditionSubSet> thenCondition;
    private boolean force;
    protected List<ConditionMatcherFactory> matcherFactories;
    private boolean enabled;

    public MultiDestConditionRouter(URL url, MultiDestCondition multiDestCondition, boolean force, boolean enabled) {
        super(url);
        this.setForce(force);
        this.enabled = enabled;
        this.matcherFactories = this.moduleModel.getExtensionLoader(ConditionMatcherFactory.class).getActivateExtensions();
        this.init(multiDestCondition.getFrom(), multiDestCondition.getTo());
    }

    public void init(Map<String, String> from, List<Map<String, String>> to) {
        try {
            if (from == null || to == null) {
                throw new IllegalArgumentException("Illegal route rule!");
            }
            String whenRule = from.get("match");
            HashMap<String, ConditionMatcher> when = StringUtils.isBlank((CharSequence)whenRule) || "true".equals(whenRule) ? new HashMap<String, ConditionMatcher>() : this.parseRule(whenRule);
            this.whenCondition = when;
            ArrayList<ConditionSubSet> thenConditions = new ArrayList<ConditionSubSet>();
            for (Map<String, String> toMap : to) {
                String thenRule = toMap.get("match");
                HashMap<String, ConditionMatcher> then = StringUtils.isBlank((CharSequence)thenRule) || "false".equals(thenRule) ? new HashMap<String, ConditionMatcher>() : this.parseRule(thenRule);
                thenConditions.add(new ConditionSubSet(then, Integer.valueOf(toMap.getOrDefault("weight", String.valueOf(100)))));
            }
            this.thenCondition = thenConditions;
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Map<String, ConditionMatcher> parseRule(String rule) throws ParseException {
        HashMap<String, ConditionMatcher> condition = new HashMap<String, ConditionMatcher>();
        if (StringUtils.isBlank((CharSequence)rule)) {
            return condition;
        }
        ConditionMatcher matcherPair = null;
        Set<String> values = null;
        Matcher matcher = ROUTE_PATTERN.matcher(rule);
        while (matcher.find()) {
            String separator = matcher.group(1);
            String content = matcher.group(2);
            if (StringUtils.isEmpty((String)separator)) {
                matcherPair = this.getMatcher(content);
                condition.put(content, matcherPair);
                continue;
            }
            if ("&".equals(separator)) {
                if (condition.get(content) == null) {
                    matcherPair = this.getMatcher(content);
                    condition.put(content, matcherPair);
                    continue;
                }
                matcherPair = (ConditionMatcher)condition.get(content);
                continue;
            }
            if ("=".equals(separator)) {
                if (matcherPair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = matcherPair.getMatches();
                values.add(content);
                continue;
            }
            if ("!=".equals(separator)) {
                if (matcherPair == null) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values = matcherPair.getMismatches();
                values.add(content);
                continue;
            }
            if (",".equals(separator)) {
                if (values == null || values.isEmpty()) {
                    throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
                }
                values.add(content);
                continue;
            }
            throw new ParseException("Illegal route rule \"" + rule + "\", The error char '" + separator + "' at index " + matcher.start() + " before \"" + content + "\".", matcher.start());
        }
        return condition;
    }

    private ConditionMatcher getMatcher(String key) {
        for (ConditionMatcherFactory factory : this.matcherFactories) {
            if (!factory.shouldMatch(key)) continue;
            return factory.createMatcher(key, this.moduleModel);
        }
        return ((ConditionMatcherFactory)this.moduleModel.getExtensionLoader(ConditionMatcherFactory.class).getExtension("param")).createMatcher(key, this.moduleModel);
    }

    @Override
    protected BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> routerSnapshotNodeHolder, Holder<String> messageHolder) throws RpcException {
        if (!this.enabled) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: ConditionRouter disabled.");
            }
            return invokers;
        }
        if (CollectionUtils.isEmpty(invokers)) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: Invokers from previous router is empty.");
            }
            return invokers;
        }
        try {
            if (!this.matchWhen(url, invocation)) {
                if (needToPrintMessage) {
                    messageHolder.set((Object)"Directly return. Reason: WhenCondition not match.");
                }
                return invokers;
            }
            if (this.thenCondition == null || this.thenCondition.size() == 0) {
                logger.warn("2-6", "condition state router thenCondition is empty", "", "The current consumer in the service blocklist. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey());
                if (needToPrintMessage) {
                    messageHolder.set((Object)"Empty return. Reason: ThenCondition is empty.");
                }
                return BitList.emptyList();
            }
            DestinationSet destinations = new DestinationSet();
            for (ConditionSubSet condition : this.thenCondition) {
                Object res = invokers.clone();
                for (Invoker<T> invoker : invokers) {
                    if (this.doMatch(invoker.getUrl(), url, null, condition.getCondition(), false)) continue;
                    ((BitList)res).remove(invoker);
                }
                if (((BitList)res).isEmpty()) continue;
                destinations.addDestination(condition.getSubSetWeight() == null ? 100 : condition.getSubSetWeight(), ((BitList)res).clone());
            }
            if (!destinations.getDestinations().isEmpty()) {
                BitList res = destinations.randDestination();
                return res;
            }
            if (this.isForce()) {
                logger.warn("2-6", "execute condition state router result list is empty. and force=true", "", "The route result is empty and force execute. consumer: " + NetUtils.getLocalHost() + ", service: " + url.getServiceKey() + ", router: " + url.getParameterAndDecoded("rule"));
                if (needToPrintMessage) {
                    messageHolder.set((Object)"Empty return. Reason: Empty result from condition and condition is force.");
                }
                return BitList.emptyList();
            }
        }
        catch (Throwable t) {
            logger.error("2-7", "execute condition state router exception", "", "Failed to execute condition router rule: " + this.getUrl() + ", invokers: " + invokers + ", cause: " + t.getMessage(), t);
        }
        if (needToPrintMessage) {
            messageHolder.set((Object)"Directly return. Reason: Error occurred ( or result is empty ).");
        }
        return invokers;
    }

    boolean matchWhen(URL url, Invocation invocation) {
        if (CollectionUtils.isEmptyMap(this.whenCondition)) {
            return true;
        }
        return this.doMatch(url, null, invocation, this.whenCondition, true);
    }

    private boolean doMatch(URL url, URL param, Invocation invocation, Map<String, ConditionMatcher> conditions, boolean isWhenCondition) {
        Map sample = url.toOriginalMap();
        for (Map.Entry<String, ConditionMatcher> entry : conditions.entrySet()) {
            ConditionMatcher matchPair = entry.getValue();
            if (matchPair.isMatch(sample, param, invocation, isWhenCondition)) continue;
            return false;
        }
        return true;
    }

    public void setWhenCondition(Map<String, ConditionMatcher> whenCondition) {
        this.whenCondition = whenCondition;
    }

    public void setThenCondition(List<ConditionSubSet> thenCondition) {
        this.thenCondition = thenCondition;
    }

    @Override
    public void setForce(boolean force) {
        this.force = force;
    }

    public Map<String, ConditionMatcher> getWhenCondition() {
        return this.whenCondition;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    public List<ConditionSubSet> getThenCondition() {
        return this.thenCondition;
    }

    public List<ConditionMatcherFactory> getMatcherFactories() {
        return this.matcherFactories;
    }

    public void setMatcherFactories(List<ConditionMatcherFactory> matcherFactories) {
        this.matcherFactories = matcherFactories;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

