/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.VsDestinationGroup;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRule;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.DestinationRuleSpec;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.destination.Subset;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class MeshRuleCache<T> {
    private final List<String> appList;
    private final Map<String, VsDestinationGroup> appToVDGroup;
    private final Map<String, Map<String, BitList<Invoker<T>>>> totalSubsetMap;
    private final BitList<Invoker<T>> unmatchedInvokers;

    private MeshRuleCache(List<String> appList, Map<String, VsDestinationGroup> appToVDGroup, Map<String, Map<String, BitList<Invoker<T>>>> totalSubsetMap, BitList<Invoker<T>> unmatchedInvokers) {
        this.appList = appList;
        this.appToVDGroup = appToVDGroup;
        this.totalSubsetMap = totalSubsetMap;
        this.unmatchedInvokers = unmatchedInvokers;
    }

    public List<String> getAppList() {
        return this.appList;
    }

    public Map<String, VsDestinationGroup> getAppToVDGroup() {
        return this.appToVDGroup;
    }

    public Map<String, Map<String, BitList<Invoker<T>>>> getTotalSubsetMap() {
        return this.totalSubsetMap;
    }

    public BitList<Invoker<T>> getUnmatchedInvokers() {
        return this.unmatchedInvokers;
    }

    public VsDestinationGroup getVsDestinationGroup(String appName) {
        return this.appToVDGroup.get(appName);
    }

    public BitList<Invoker<T>> getSubsetInvokers(String appName, String subset) {
        BitList<Invoker<T>> subsetInvokers;
        Map<String, BitList<Invoker<T>>> appToSubSets = this.totalSubsetMap.get(appName);
        if (CollectionUtils.isNotEmptyMap(appToSubSets) && CollectionUtils.isNotEmpty(subsetInvokers = appToSubSets.get(subset))) {
            return subsetInvokers;
        }
        return BitList.emptyList();
    }

    public boolean containsRule() {
        return !this.totalSubsetMap.isEmpty();
    }

    public static <T> MeshRuleCache<T> build(String protocolServiceKey, BitList<Invoker<T>> invokers, Map<String, VsDestinationGroup> vsDestinationGroupMap) {
        if (CollectionUtils.isNotEmptyMap(vsDestinationGroupMap)) {
            BitList<Invoker<T>> unmatchedInvokers = new BitList<Invoker<T>>(invokers.getOriginList(), true);
            HashMap<String, Map> totalSubsetMap = new HashMap<String, Map>();
            for (Invoker<T> invoker : invokers) {
                String remoteApplication = invoker.getUrl().getRemoteApplication();
                if (StringUtils.isEmpty((String)remoteApplication) || "unknown".equals(remoteApplication)) {
                    unmatchedInvokers.add(invoker);
                    continue;
                }
                VsDestinationGroup vsDestinationGroup = vsDestinationGroupMap.get(remoteApplication);
                if (vsDestinationGroup == null) {
                    unmatchedInvokers.add(invoker);
                    continue;
                }
                Map subsetMap = totalSubsetMap.computeIfAbsent(remoteApplication, k -> new HashMap());
                boolean matched = false;
                for (DestinationRule destinationRule : vsDestinationGroup.getDestinationRuleList()) {
                    DestinationRuleSpec destinationRuleSpec = destinationRule.getSpec();
                    List<Subset> subsetList = destinationRuleSpec.getSubsets();
                    for (Subset subset : subsetList) {
                        String subsetName = subset.getName();
                        List subsetInvokers = subsetMap.computeIfAbsent(subsetName, k -> new BitList(invokers.getOriginList(), true));
                        Map<String, String> labels = subset.getLabels();
                        if (!MeshRuleCache.isLabelMatch(invoker.getUrl(), protocolServiceKey, labels)) continue;
                        subsetInvokers.add(invoker);
                        matched = true;
                    }
                }
                if (matched) continue;
                unmatchedInvokers.add(invoker);
            }
            return new MeshRuleCache<T>(new LinkedList<String>(vsDestinationGroupMap.keySet()), Collections.unmodifiableMap(vsDestinationGroupMap), Collections.unmodifiableMap(totalSubsetMap), unmatchedInvokers);
        }
        return new MeshRuleCache<T>(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), invokers);
    }

    public static <T> MeshRuleCache<T> emptyCache() {
        return new MeshRuleCache<T>(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), BitList.emptyList());
    }

    protected static boolean isLabelMatch(URL url, String protocolServiceKey, Map<String, String> inputMap) {
        if (inputMap == null || inputMap.size() == 0) {
            return true;
        }
        for (Map.Entry<String, String> entry : inputMap.entrySet()) {
            String originMapValue;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.equals(originMapValue = url.getOriginalServiceParameter(protocolServiceKey, key))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshRuleCache ruleCache = (MeshRuleCache)o;
        return Objects.equals(this.appList, ruleCache.appList) && Objects.equals(this.appToVDGroup, ruleCache.appToVDGroup) && Objects.equals(this.totalSubsetMap, ruleCache.totalSubsetMap) && Objects.equals(this.unmatchedInvokers, ruleCache.unmatchedInvokers);
    }

    public int hashCode() {
        return Objects.hash(this.appList, this.appToVDGroup, this.totalSubsetMap, this.unmatchedInvokers);
    }
}

