/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.beans.support;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAccessor;

public class InstantiationStrategy {
    private ScopeModelAccessor scopeModelAccessor;

    public InstantiationStrategy() {
        this(null);
    }

    public InstantiationStrategy(ScopeModelAccessor scopeModelAccessor) {
        this.scopeModelAccessor = scopeModelAccessor;
    }

    public <T> T instantiate(Class<T> type) throws ReflectiveOperationException {
        Constructor targetConstructor;
        Constructor<?>[] declaredConstructors;
        Constructor defaultConstructor = null;
        try {
            defaultConstructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ArrayList matchedConstructors = new ArrayList();
        for (Constructor<?> constructor : declaredConstructors = type.getConstructors()) {
            if (!this.isMatched(constructor)) continue;
            matchedConstructors.add(constructor);
        }
        if (defaultConstructor != null) {
            matchedConstructors.remove(defaultConstructor);
        }
        if (matchedConstructors.size() > 1) {
            throw new IllegalArgumentException("Expect only one but found " + matchedConstructors.size() + " matched constructors for type: " + type.getName() + ", matched constructors: " + matchedConstructors);
        }
        if (matchedConstructors.size() == 1) {
            targetConstructor = (Constructor)matchedConstructors.get(0);
        } else if (defaultConstructor != null) {
            targetConstructor = defaultConstructor;
        } else {
            throw new IllegalArgumentException("None matched constructor was found for type: " + type.getName());
        }
        Class<?>[] parameterTypes = targetConstructor.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            args[i] = this.getArgumentValueForType(parameterTypes[i]);
        }
        return targetConstructor.newInstance(args);
    }

    private boolean isMatched(Constructor<?> constructor) {
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (this.isSupportedConstructorParameterType(parameterType)) continue;
            return false;
        }
        return true;
    }

    private boolean isSupportedConstructorParameterType(Class<?> parameterType) {
        return ScopeModel.class.isAssignableFrom(parameterType);
    }

    private Object getArgumentValueForType(Class parameterType) {
        if (this.scopeModelAccessor != null) {
            if (parameterType == ScopeModel.class) {
                return this.scopeModelAccessor.getScopeModel();
            }
            if (parameterType == FrameworkModel.class) {
                return this.scopeModelAccessor.getFrameworkModel();
            }
            if (parameterType == ApplicationModel.class) {
                return this.scopeModelAccessor.getApplicationModel();
            }
            if (parameterType == ModuleModel.class) {
                return this.scopeModelAccessor.getModuleModel();
            }
        }
        return null;
    }
}

