/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.status.support;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.status.Status;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.common.system.OperatingSystemBeanManager;

@Activate
public class LoadStatusChecker
implements StatusChecker {
    @Override
    public Status check() {
        double load = OperatingSystemBeanManager.getOperatingSystemBean().getSystemLoadAverage();
        if (load == -1.0) {
            load = OperatingSystemBeanManager.getSystemCpuUsage();
        }
        int cpu = OperatingSystemBeanManager.getOperatingSystemBean().getAvailableProcessors();
        Status.Level level = load < 0.0 ? Status.Level.UNKNOWN : (load < (double)cpu ? Status.Level.OK : Status.Level.WARN);
        String message = (load < 0.0 ? "" : "load:" + load + ",") + "cpu:" + cpu;
        return new Status(level, message);
    }
}

