/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.bootstrap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.config.configcenter.wrapper.CompositeDynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.common.lang.ShutdownHookCallbacks;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.concurrent.ScheduledCompletableFuture;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.DubboShutdownHook;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrapStartStopListener;
import org.apache.dubbo.config.bootstrap.builders.ApplicationBuilder;
import org.apache.dubbo.config.bootstrap.builders.ConsumerBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProtocolBuilder;
import org.apache.dubbo.config.bootstrap.builders.ProviderBuilder;
import org.apache.dubbo.config.bootstrap.builders.ReferenceBuilder;
import org.apache.dubbo.config.bootstrap.builders.RegistryBuilder;
import org.apache.dubbo.config.bootstrap.builders.ServiceBuilder;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.metadata.ConfigurableMetadataServiceExporter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.config.utils.ReferenceConfigCache;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceExporter;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.metadata.report.MetadataReportFactory;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReportFactory;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DubboBootstrap {
    public static final String DEFAULT_REGISTRY_ID = "REGISTRY#DEFAULT";
    public static final String DEFAULT_PROTOCOL_ID = "PROTOCOL#DEFAULT";
    public static final String DEFAULT_SERVICE_ID = "SERVICE#DEFAULT";
    public static final String DEFAULT_REFERENCE_ID = "REFERENCE#DEFAULT";
    public static final String DEFAULT_PROVIDER_ID = "PROVIDER#DEFAULT";
    public static final String DEFAULT_CONSUMER_ID = "CONSUMER#DEFAULT";
    private static final String NAME = DubboBootstrap.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static volatile DubboBootstrap instance;
    private final AtomicBoolean awaited = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Lock destroyLock = new ReentrantLock();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
    private final ConfigManager configManager;
    private final Environment environment;
    private ReferenceConfigCache cache;
    private volatile boolean exportAsync;
    private volatile boolean referAsync;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean ready = new AtomicBoolean(false);
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private volatile ServiceInstance serviceInstance;
    private volatile MetadataService metadataService;
    private volatile MetadataServiceExporter metadataServiceExporter;
    private Map<String, ServiceConfigBase<?>> exportedServices = new ConcurrentHashMap();
    private List<Future<?>> asyncExportingFutures = new ArrayList();
    private List<CompletableFuture<Object>> asyncReferringFutures = new ArrayList<CompletableFuture<Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DubboBootstrap getInstance() {
        if (instance != null) return instance;
        Class<DubboBootstrap> clazz = DubboBootstrap.class;
        synchronized (DubboBootstrap.class) {
            if (instance != null) return instance;
            instance = new DubboBootstrap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DubboBootstrap() {
        this.configManager = ApplicationModel.getConfigManager();
        this.environment = ApplicationModel.getEnvironment();
        DubboShutdownHook.getDubboShutdownHook().register();
        ShutdownHookCallbacks.INSTANCE.addCallback(this::destroy);
    }

    public void unRegisterShutdownHook() {
        DubboShutdownHook.getDubboShutdownHook().unregister();
    }

    private boolean isOnlyRegisterProvider() {
        Boolean registerConsumer = this.getApplication().getRegisterConsumer();
        return registerConsumer == null || registerConsumer == false;
    }

    private String getMetadataType() {
        String type = this.getApplication().getMetadataType();
        if (StringUtils.isEmpty((String)type)) {
            type = "local";
        }
        return type;
    }

    public DubboBootstrap metadataReport(MetadataReportConfig metadataReportConfig) {
        this.configManager.addMetadataReport(metadataReportConfig);
        return this;
    }

    public DubboBootstrap metadataReports(List<MetadataReportConfig> metadataReportConfigs) {
        if (CollectionUtils.isEmpty(metadataReportConfigs)) {
            return this;
        }
        this.configManager.addMetadataReports(metadataReportConfigs);
        return this;
    }

    public DubboBootstrap application(String name) {
        return this.application(name, builder -> {});
    }

    public DubboBootstrap application(String name, Consumer<ApplicationBuilder> consumerBuilder) {
        ApplicationBuilder builder = this.createApplicationBuilder(name);
        consumerBuilder.accept(builder);
        return this.application(builder.build());
    }

    public DubboBootstrap application(ApplicationConfig applicationConfig) {
        this.configManager.setApplication(applicationConfig);
        return this;
    }

    public DubboBootstrap registry(Consumer<RegistryBuilder> consumerBuilder) {
        return this.registry(DEFAULT_REGISTRY_ID, consumerBuilder);
    }

    public DubboBootstrap registry(String id, Consumer<RegistryBuilder> consumerBuilder) {
        RegistryBuilder builder = this.createRegistryBuilder(id);
        consumerBuilder.accept(builder);
        return this.registry(builder.build());
    }

    public DubboBootstrap registry(RegistryConfig registryConfig) {
        this.configManager.addRegistry(registryConfig);
        return this;
    }

    public DubboBootstrap registries(List<RegistryConfig> registryConfigs) {
        if (CollectionUtils.isEmpty(registryConfigs)) {
            return this;
        }
        registryConfigs.forEach(this::registry);
        return this;
    }

    public DubboBootstrap protocol(Consumer<ProtocolBuilder> consumerBuilder) {
        return this.protocol(DEFAULT_PROTOCOL_ID, consumerBuilder);
    }

    public DubboBootstrap protocol(String id, Consumer<ProtocolBuilder> consumerBuilder) {
        ProtocolBuilder builder = this.createProtocolBuilder(id);
        consumerBuilder.accept(builder);
        return this.protocol(builder.build());
    }

    public DubboBootstrap protocol(ProtocolConfig protocolConfig) {
        return this.protocols(Collections.singletonList(protocolConfig));
    }

    public DubboBootstrap protocols(List<ProtocolConfig> protocolConfigs) {
        if (CollectionUtils.isEmpty(protocolConfigs)) {
            return this;
        }
        this.configManager.addProtocols(protocolConfigs);
        return this;
    }

    public <S> DubboBootstrap service(Consumer<ServiceBuilder<S>> consumerBuilder) {
        return this.service(DEFAULT_SERVICE_ID, consumerBuilder);
    }

    public <S> DubboBootstrap service(String id, Consumer<ServiceBuilder<S>> consumerBuilder) {
        ServiceBuilder builder = this.createServiceBuilder(id);
        consumerBuilder.accept(builder);
        return this.service(builder.build());
    }

    public DubboBootstrap service(ServiceConfig<?> serviceConfig) {
        this.configManager.addService(serviceConfig);
        return this;
    }

    public DubboBootstrap services(List<ServiceConfig> serviceConfigs) {
        if (CollectionUtils.isEmpty(serviceConfigs)) {
            return this;
        }
        serviceConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addService(arg_0));
        return this;
    }

    public <S> DubboBootstrap reference(Consumer<ReferenceBuilder<S>> consumerBuilder) {
        return this.reference(DEFAULT_REFERENCE_ID, consumerBuilder);
    }

    public <S> DubboBootstrap reference(String id, Consumer<ReferenceBuilder<S>> consumerBuilder) {
        ReferenceBuilder builder = this.createReferenceBuilder(id);
        consumerBuilder.accept(builder);
        return this.reference(builder.build());
    }

    public DubboBootstrap reference(ReferenceConfig<?> referenceConfig) {
        this.configManager.addReference(referenceConfig);
        return this;
    }

    public DubboBootstrap references(List<ReferenceConfig> referenceConfigs) {
        if (CollectionUtils.isEmpty(referenceConfigs)) {
            return this;
        }
        referenceConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addReference(arg_0));
        return this;
    }

    public DubboBootstrap provider(Consumer<ProviderBuilder> builderConsumer) {
        return this.provider(DEFAULT_PROVIDER_ID, builderConsumer);
    }

    public DubboBootstrap provider(String id, Consumer<ProviderBuilder> builderConsumer) {
        ProviderBuilder builder = this.createProviderBuilder(id);
        builderConsumer.accept(builder);
        return this.provider(builder.build());
    }

    public DubboBootstrap provider(ProviderConfig providerConfig) {
        return this.providers(Collections.singletonList(providerConfig));
    }

    public DubboBootstrap providers(List<ProviderConfig> providerConfigs) {
        if (CollectionUtils.isEmpty(providerConfigs)) {
            return this;
        }
        providerConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addProvider(arg_0));
        return this;
    }

    public DubboBootstrap consumer(Consumer<ConsumerBuilder> builderConsumer) {
        return this.consumer(DEFAULT_CONSUMER_ID, builderConsumer);
    }

    public DubboBootstrap consumer(String id, Consumer<ConsumerBuilder> builderConsumer) {
        ConsumerBuilder builder = this.createConsumerBuilder(id);
        builderConsumer.accept(builder);
        return this.consumer(builder.build());
    }

    public DubboBootstrap consumer(ConsumerConfig consumerConfig) {
        return this.consumers(Collections.singletonList(consumerConfig));
    }

    public DubboBootstrap consumers(List<ConsumerConfig> consumerConfigs) {
        if (CollectionUtils.isEmpty(consumerConfigs)) {
            return this;
        }
        consumerConfigs.forEach(arg_0 -> ((ConfigManager)this.configManager).addConsumer(arg_0));
        return this;
    }

    public DubboBootstrap configCenter(ConfigCenterConfig configCenterConfig) {
        return this.configCenters(Collections.singletonList(configCenterConfig));
    }

    public DubboBootstrap configCenters(List<ConfigCenterConfig> configCenterConfigs) {
        if (CollectionUtils.isEmpty(configCenterConfigs)) {
            return this;
        }
        this.configManager.addConfigCenters(configCenterConfigs);
        return this;
    }

    public DubboBootstrap monitor(MonitorConfig monitor) {
        this.configManager.setMonitor(monitor);
        return this;
    }

    public DubboBootstrap metrics(MetricsConfig metrics) {
        this.configManager.setMetrics(metrics);
        return this;
    }

    public DubboBootstrap module(ModuleConfig module) {
        this.configManager.setModule(module);
        return this;
    }

    public DubboBootstrap ssl(SslConfig sslConfig) {
        this.configManager.setSsl(sslConfig);
        return this;
    }

    public DubboBootstrap cache(ReferenceConfigCache cache) {
        this.cache = cache;
        return this;
    }

    public ReferenceConfigCache getCache() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        return this.cache;
    }

    public DubboBootstrap exportAsync() {
        this.exportAsync = true;
        return this;
    }

    public DubboBootstrap referAsync() {
        this.referAsync = true;
        return this;
    }

    @Deprecated
    public void init() {
        this.initialize();
    }

    public void initialize() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        ApplicationModel.initFrameworkExts();
        this.startConfigCenter();
        this.loadRemoteConfigs();
        this.checkGlobalConfigs();
        this.startMetadataCenter();
        this.initMetadataService();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(NAME + " has been initialized!");
        }
    }

    private void checkGlobalConfigs() {
        Collection providers;
        ConfigValidationUtils.validateApplicationConfig(this.getApplication());
        Collection metadatas = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty((Collection)metadatas)) {
            MetadataReportConfig metadataReportConfig = new MetadataReportConfig();
            metadataReportConfig.refresh();
            if (metadataReportConfig.isValid()) {
                this.configManager.addMetadataReport(metadataReportConfig);
                metadatas = this.configManager.getMetadataConfigs();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)metadatas)) {
            for (Object metadataReportConfig : metadatas) {
                metadataReportConfig.refresh();
                ConfigValidationUtils.validateMetadataConfig((MetadataReportConfig)metadataReportConfig);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(providers = this.configManager.getProviders()))) {
            this.configManager.getDefaultProvider().orElseGet(() -> {
                ProviderConfig providerConfig = new ProviderConfig();
                this.configManager.addProvider(providerConfig);
                providerConfig.refresh();
                return providerConfig;
            });
        }
        for (ProviderConfig providerConfig : this.configManager.getProviders()) {
            ConfigValidationUtils.validateProviderConfig(providerConfig);
        }
        Collection consumers = this.configManager.getConsumers();
        if (CollectionUtils.isEmpty((Collection)consumers)) {
            this.configManager.getDefaultConsumer().orElseGet(() -> {
                ConsumerConfig consumerConfig = new ConsumerConfig();
                this.configManager.addConsumer(consumerConfig);
                consumerConfig.refresh();
                return consumerConfig;
            });
        }
        for (ConsumerConfig consumerConfig : this.configManager.getConsumers()) {
            ConfigValidationUtils.validateConsumerConfig(consumerConfig);
        }
        ConfigValidationUtils.validateMonitorConfig(this.getMonitor());
        ConfigValidationUtils.validateMetricsConfig(this.getMetrics());
        ConfigValidationUtils.validateModuleConfig(this.getModule());
        ConfigValidationUtils.validateSslConfig(this.getSsl());
    }

    private void startConfigCenter() {
        this.useRegistryAsConfigCenterIfNecessary();
        Collection configCenters = this.configManager.getConfigCenters();
        if (CollectionUtils.isEmpty((Collection)configCenters)) {
            ConfigCenterConfig configCenterConfig = new ConfigCenterConfig();
            configCenterConfig.refresh();
            if (configCenterConfig.isValid()) {
                this.configManager.addConfigCenter(configCenterConfig);
                configCenters = this.configManager.getConfigCenters();
            }
        } else {
            for (ConfigCenterConfig configCenterConfig : configCenters) {
                configCenterConfig.refresh();
                ConfigValidationUtils.validateConfigCenterConfig(configCenterConfig);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)configCenters)) {
            CompositeDynamicConfiguration compositeDynamicConfiguration = new CompositeDynamicConfiguration();
            for (ConfigCenterConfig configCenter : configCenters) {
                compositeDynamicConfiguration.addConfiguration(this.prepareEnvironment(configCenter));
            }
            this.environment.setDynamicConfiguration((DynamicConfiguration)compositeDynamicConfiguration);
        }
        this.configManager.refreshAll();
    }

    private void startMetadataCenter() {
        this.useRegistryAsMetadataCenterIfNecessary();
        ApplicationConfig applicationConfig = this.getApplication();
        String metadataType = applicationConfig.getMetadataType();
        Collection metadataReportConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isEmpty((Collection)metadataReportConfigs)) {
            if ("remote".equals(metadataType)) {
                throw new IllegalStateException("No MetadataConfig found, Metadata Center address is required when 'metadata=remote' is enabled.");
            }
            return;
        }
        for (MetadataReportConfig metadataReportConfig : metadataReportConfigs) {
            ConfigValidationUtils.validateMetadataConfig(metadataReportConfig);
            if (!metadataReportConfig.isValid()) continue;
            MetadataReportInstance.init((MetadataReportConfig)metadataReportConfig);
        }
    }

    private void useRegistryAsConfigCenterIfNecessary() {
        if (this.environment.getDynamicConfiguration().isPresent()) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.configManager.getConfigCenters())) {
            return;
        }
        this.configManager.getDefaultRegistries().stream().filter(this::isUsedRegistryAsConfigCenter).map(this::registryAsConfigCenter).forEach(arg_0 -> ((ConfigManager)this.configManager).addConfigCenter(arg_0));
    }

    private boolean isUsedRegistryAsConfigCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsConfigCenter(), "config", DynamicConfigurationFactory.class);
    }

    private ConfigCenterConfig registryAsConfigCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        Integer port = registryConfig.getPort();
        String id = "config-center-" + protocol + "-" + port;
        if (this.configManager.getConfigCenter(id) != null) {
            return null;
        }
        ConfigCenterConfig cc = new ConfigCenterConfig();
        cc.setId(id);
        if (cc.getParameters() == null) {
            cc.setParameters(new HashMap());
        }
        if (registryConfig.getParameters() != null) {
            cc.getParameters().putAll(registryConfig.getParameters());
        }
        cc.getParameters().put("client", registryConfig.getClient());
        cc.setProtocol(protocol);
        cc.setPort(port);
        if (StringUtils.isNotEmpty((String)registryConfig.getGroup())) {
            cc.setGroup(registryConfig.getGroup());
        }
        cc.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        cc.setNamespace(registryConfig.getGroup());
        cc.setUsername(registryConfig.getUsername());
        cc.setPassword(registryConfig.getPassword());
        if (registryConfig.getTimeout() != null) {
            cc.setTimeout(Long.valueOf(registryConfig.getTimeout().longValue()));
        }
        cc.setHighestPriority(Boolean.valueOf(false));
        return cc;
    }

    private void useRegistryAsMetadataCenterIfNecessary() {
        Collection metadataConfigs = this.configManager.getMetadataConfigs();
        if (CollectionUtils.isNotEmpty((Collection)metadataConfigs)) {
            return;
        }
        this.configManager.getDefaultRegistries().stream().filter(this::isUsedRegistryAsMetadataCenter).map(this::registryAsMetadataCenter).forEach(arg_0 -> ((ConfigManager)this.configManager).addMetadataReport(arg_0));
    }

    private boolean isUsedRegistryAsMetadataCenter(RegistryConfig registryConfig) {
        return this.isUsedRegistryAsCenter(registryConfig, () -> ((RegistryConfig)registryConfig).getUseAsMetadataCenter(), "metadata", MetadataReportFactory.class);
    }

    private boolean isUsedRegistryAsCenter(RegistryConfig registryConfig, Supplier<Boolean> usedRegistryAsCenter, String centerType, Class<?> extensionClass) {
        boolean supported;
        Boolean configuredValue = usedRegistryAsCenter.get();
        if (configuredValue != null) {
            supported = configuredValue;
        } else {
            String protocol = registryConfig.getProtocol();
            supported = this.supportsExtension(extensionClass, protocol);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("No value is configured in the registry, the %s extension[name : %s] %s as the %s center", extensionClass.getSimpleName(), protocol, supported ? "supports" : "does not support", centerType));
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info(String.format("The registry[%s] will be %s as the %s center", registryConfig, supported ? "used" : "not used", centerType));
        }
        return supported;
    }

    private boolean supportsExtension(Class<?> extensionClass, String name) {
        if (StringUtils.isNotEmpty((String)name)) {
            ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(extensionClass);
            return extensionLoader.hasExtension(name);
        }
        return false;
    }

    private MetadataReportConfig registryAsMetadataCenter(RegistryConfig registryConfig) {
        String protocol = registryConfig.getProtocol();
        Integer port = registryConfig.getPort();
        String id = "metadata-center-" + protocol + "-" + port;
        if (this.configManager.getMetadataConfig(id) != null) {
            return null;
        }
        MetadataReportConfig metadataReportConfig = new MetadataReportConfig();
        metadataReportConfig.setId(id);
        if (metadataReportConfig.getParameters() == null) {
            metadataReportConfig.setParameters(new HashMap());
        }
        if (registryConfig.getParameters() != null) {
            metadataReportConfig.getParameters().putAll(registryConfig.getParameters());
        }
        metadataReportConfig.getParameters().put("client", registryConfig.getClient());
        metadataReportConfig.setGroup(registryConfig.getGroup());
        metadataReportConfig.setAddress(this.getRegistryCompatibleAddress(registryConfig));
        metadataReportConfig.setUsername(registryConfig.getUsername());
        metadataReportConfig.setPassword(registryConfig.getPassword());
        metadataReportConfig.setTimeout(registryConfig.getTimeout());
        metadataReportConfig.setRegistry(registryConfig.getId());
        return metadataReportConfig;
    }

    private String getRegistryCompatibleAddress(RegistryConfig registryConfig) {
        String registryAddress = registryConfig.getAddress();
        Object[] addresses = CommonConstants.REGISTRY_SPLIT_PATTERN.split(registryAddress);
        if (ArrayUtils.isEmpty((Object[])addresses)) {
            throw new IllegalStateException("Invalid registry address found.");
        }
        Object address = addresses[0];
        StringBuilder metadataAddressBuilder = new StringBuilder();
        URL url = URL.valueOf((String)address);
        String protocolFromAddress = url.getProtocol();
        if (StringUtils.isEmpty((String)protocolFromAddress)) {
            String protocolFromConfig = registryConfig.getProtocol();
            metadataAddressBuilder.append(protocolFromConfig).append("://");
        }
        metadataAddressBuilder.append((String)address);
        return metadataAddressBuilder.toString();
    }

    private void loadRemoteConfigs() {
        ArrayList tmpRegistries = new ArrayList();
        Set registryIds = this.configManager.getRegistryIds();
        registryIds.forEach(id -> {
            if (tmpRegistries.stream().noneMatch(reg -> reg.getId().equals(id))) {
                tmpRegistries.add(this.configManager.getRegistry(id).orElseGet(() -> {
                    RegistryConfig registryConfig = new RegistryConfig();
                    registryConfig.setId(id);
                    registryConfig.refresh();
                    return registryConfig;
                }));
            }
        });
        this.configManager.addRegistries(tmpRegistries);
        ArrayList tmpProtocols = new ArrayList();
        Set protocolIds = this.configManager.getProtocolIds();
        protocolIds.forEach(id -> {
            if (tmpProtocols.stream().noneMatch(prot -> prot.getId().equals(id))) {
                tmpProtocols.add(this.configManager.getProtocol(id).orElseGet(() -> {
                    ProtocolConfig protocolConfig = new ProtocolConfig();
                    protocolConfig.setId(id);
                    protocolConfig.refresh();
                    return protocolConfig;
                }));
            }
        });
        this.configManager.addProtocols(tmpProtocols);
    }

    private void initMetadataService() {
        this.metadataService = WritableMetadataService.getDefaultExtension();
        this.metadataServiceExporter = new ConfigurableMetadataServiceExporter(this.metadataService);
    }

    public DubboBootstrap start() {
        if (this.started.compareAndSet(false, true)) {
            this.destroyed.set(false);
            this.ready.set(false);
            this.initialize();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(NAME + " is starting...");
            }
            this.exportServices();
            if (!this.isOnlyRegisterProvider() || this.hasExportedServices()) {
                this.exportMetadataService();
                this.registerServiceInstance();
            }
            this.referServices();
            if (this.asyncExportingFutures.size() > 0) {
                new Thread(() -> {
                    try {
                        this.awaitFinish();
                    }
                    catch (Exception e) {
                        this.logger.warn(NAME + " exportAsync occurred an exception.");
                    }
                    this.ready.set(true);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(NAME + " is ready.");
                    }
                    ExtensionLoader exts = ExtensionLoader.getExtensionLoader(DubboBootstrapStartStopListener.class);
                    exts.getSupportedExtensionInstances().forEach(ext -> ext.onStart(this));
                }).start();
            } else {
                this.ready.set(true);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is ready.");
                }
                ExtensionLoader exts = ExtensionLoader.getExtensionLoader(DubboBootstrapStartStopListener.class);
                exts.getSupportedExtensionInstances().forEach(ext -> ext.onStart(this));
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info(NAME + " has started.");
            }
        }
        return this;
    }

    private boolean hasExportedServices() {
        return !this.metadataService.getExportedURLs().isEmpty();
    }

    public DubboBootstrap await() {
        if (!this.awaited.get() && !this.executorService.isShutdown()) {
            this.executeMutually(() -> {
                while (!this.awaited.get()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(NAME + " awaiting ...");
                    }
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        return this;
    }

    public DubboBootstrap awaitFinish() throws Exception {
        CompletableFuture<Void> future;
        this.logger.info(NAME + " waiting services exporting / referring ...");
        if (this.exportAsync && this.asyncExportingFutures.size() > 0) {
            future = CompletableFuture.allOf(this.asyncExportingFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        if (this.referAsync && this.asyncReferringFutures.size() > 0) {
            future = CompletableFuture.allOf(this.asyncReferringFutures.toArray(new CompletableFuture[0]));
            future.get();
        }
        this.logger.info("Service export / refer finished.");
        return this;
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isReady() {
        return this.ready.get();
    }

    public DubboBootstrap stop() throws IllegalStateException {
        this.destroy();
        return this;
    }

    private ApplicationBuilder createApplicationBuilder(String name) {
        return new ApplicationBuilder().name(name);
    }

    private RegistryBuilder createRegistryBuilder(String id) {
        return new RegistryBuilder().id(id);
    }

    private ProtocolBuilder createProtocolBuilder(String id) {
        return new ProtocolBuilder().id(id);
    }

    private ServiceBuilder createServiceBuilder(String id) {
        return new ServiceBuilder().id(id);
    }

    private ReferenceBuilder createReferenceBuilder(String id) {
        return new ReferenceBuilder().id(id);
    }

    private ProviderBuilder createProviderBuilder(String id) {
        return (ProviderBuilder)new ProviderBuilder().id(id);
    }

    private ConsumerBuilder createConsumerBuilder(String id) {
        return (ConsumerBuilder)new ConsumerBuilder().id(id);
    }

    private DynamicConfiguration prepareEnvironment(ConfigCenterConfig configCenter) {
        if (configCenter.isValid()) {
            if (!configCenter.checkOrUpdateInited()) {
                return null;
            }
            DynamicConfiguration dynamicConfiguration = DynamicConfiguration.getDynamicConfiguration((URL)configCenter.toUrl());
            String configContent = dynamicConfiguration.getProperties(configCenter.getConfigFile(), configCenter.getGroup());
            String appGroup = this.getApplication().getName();
            String appConfigContent = null;
            if (StringUtils.isNotEmpty((String)appGroup)) {
                appConfigContent = dynamicConfiguration.getProperties(StringUtils.isNotEmpty((String)configCenter.getAppConfigFile()) ? configCenter.getAppConfigFile() : configCenter.getConfigFile(), appGroup);
            }
            try {
                this.environment.setConfigCenterFirst(configCenter.isHighestPriority().booleanValue());
                Map globalRemoteProperties = ConfigurationUtils.parseProperties((String)configContent);
                if (CollectionUtils.isEmptyMap((Map)globalRemoteProperties)) {
                    this.logger.info("No global configuration in config center");
                }
                this.environment.updateExternalConfigurationMap(globalRemoteProperties);
                Map appRemoteProperties = ConfigurationUtils.parseProperties((String)appConfigContent);
                if (CollectionUtils.isEmptyMap((Map)appRemoteProperties)) {
                    this.logger.info("No application level configuration in config center");
                }
                this.environment.updateAppExternalConfigurationMap(appRemoteProperties);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse configurations from Config Center.", e);
            }
            return dynamicConfiguration;
        }
        return null;
    }

    private void exportMetadataService() {
        this.metadataServiceExporter.export();
    }

    private void unexportMetadataService() {
        if (this.metadataServiceExporter != null && this.metadataServiceExporter.isExported()) {
            this.metadataServiceExporter.unexport();
        }
    }

    private void exportServices() {
        this.configManager.getServices().forEach(sc -> {
            ServiceConfig serviceConfig = (ServiceConfig)((Object)sc);
            serviceConfig.setBootstrap(this);
            if (this.exportAsync) {
                ScheduledExecutorService executor = this.executorRepository.getServiceExporterExecutor();
                Future<?> future = executor.submit(() -> {
                    try {
                        this.exportService(serviceConfig);
                    }
                    catch (Throwable t) {
                        this.logger.error("export async catch error : " + t.getMessage(), t);
                    }
                });
                this.asyncExportingFutures.add(future);
            } else {
                this.exportService(serviceConfig);
            }
        });
    }

    private void exportService(ServiceConfig sc) {
        if (this.exportedServices.containsKey(sc.getServiceName())) {
            throw new IllegalStateException("There are multiple ServiceBean instances with the same service name: [" + sc.getServiceName() + "], instances: [" + this.exportedServices.get(sc.getServiceName()).toString() + ", " + sc.toString() + "]. Only one service can be exported for the same triple (group, interface, version), please modify the group or version if you really need to export multiple services of the same interface.");
        }
        sc.export();
        this.exportedServices.put(sc.getServiceName(), sc);
    }

    private void unexportServices() {
        this.exportedServices.forEach((serviceName, sc) -> {
            this.configManager.removeConfig((AbstractConfig)sc);
            sc.unexport();
        });
        this.asyncExportingFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncExportingFutures.clear();
        this.exportedServices.clear();
    }

    private void referServices() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        this.configManager.getReferences().forEach(rc -> {
            ReferenceConfig referenceConfig = (ReferenceConfig)((Object)rc);
            referenceConfig.setBootstrap(this);
            if (rc.shouldInit()) {
                if (this.referAsync) {
                    CompletableFuture future = ScheduledCompletableFuture.submit((ScheduledExecutorService)this.executorRepository.getServiceExporterExecutor(), () -> this.cache.get(rc));
                    this.asyncReferringFutures.add(future);
                } else {
                    this.cache.get(rc);
                }
            }
        });
    }

    private void unreferServices() {
        if (this.cache == null) {
            this.cache = ReferenceConfigCache.getCache();
        }
        this.asyncReferringFutures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        this.asyncReferringFutures.clear();
        this.cache.destroyAll();
    }

    private void registerServiceInstance() {
        if (CollectionUtils.isEmpty((Collection)AbstractRegistryFactory.getServiceDiscoveries())) {
            return;
        }
        ApplicationConfig application = this.getApplication();
        String serviceName = application.getName();
        URL exportedURL = this.selectMetadataServiceExportedURL();
        String host = exportedURL.getHost();
        int port = exportedURL.getPort();
        ServiceInstance serviceInstance = this.createServiceInstance(serviceName, host, port);
        this.doRegisterServiceInstance(serviceInstance);
        this.executorRepository.nextScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                InMemoryWritableMetadataService localMetadataService = (InMemoryWritableMetadataService)WritableMetadataService.getDefaultExtension();
                localMetadataService.blockUntilUpdated();
                ServiceInstanceMetadataUtils.refreshMetadataAndInstance();
            }
            catch (Throwable e) {
                this.logger.error("refresh metadata and instance failed", e);
            }
        }, 0L, ConfigurationUtils.get((String)"dubbo.application.metadata.delay", (int)5000), TimeUnit.MILLISECONDS);
    }

    private void doRegisterServiceInstance(ServiceInstance serviceInstance) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Start publishing metadata to remote center, this only makes sense for applications enabled remote metadata center.");
        }
        this.publishMetadataToRemote(serviceInstance);
        this.logger.info("Start registering instance address to registry.");
        AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> {
            ServiceInstanceMetadataUtils.calInstanceRevision((ServiceDiscovery)serviceDiscovery, (ServiceInstance)serviceInstance);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Start registering instance address to registry" + serviceDiscovery.getUrl() + ", instance " + serviceInstance);
            }
            serviceDiscovery.register(serviceInstance);
        });
    }

    private void publishMetadataToRemote(ServiceInstance serviceInstance) {
        RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService();
        remoteMetadataService.publishMetadata(serviceInstance.getServiceName());
    }

    private URL selectMetadataServiceExportedURL() {
        URL selectedURL = null;
        SortedSet urlValues = this.metadataService.getExportedURLs();
        for (String urlValue : urlValues) {
            URL url = URL.valueOf((String)urlValue);
            if ("rest".equals(url.getProtocol())) {
                selectedURL = url;
                break;
            }
            selectedURL = url;
        }
        if (selectedURL == null && CollectionUtils.isNotEmpty((Collection)urlValues)) {
            selectedURL = URL.valueOf((String)((String)urlValues.iterator().next()));
        }
        return selectedURL;
    }

    private void unregisterServiceInstance() {
        if (this.serviceInstance != null) {
            AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> serviceDiscovery.unregister(this.serviceInstance));
        }
    }

    private ServiceInstance createServiceInstance(String serviceName, String host, int port) {
        this.serviceInstance = new DefaultServiceInstance(serviceName, host, Integer.valueOf(port));
        ServiceInstanceMetadataUtils.setMetadataStorageType((ServiceInstance)this.serviceInstance, (String)this.getMetadataType());
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(ServiceInstanceCustomizer.class);
        loader.getSupportedExtensionInstances().forEach(customizer -> customizer.customize(this.serviceInstance));
        return this.serviceInstance;
    }

    public void destroy() {
        if (this.destroyLock.tryLock()) {
            try {
                if (this.destroyed.compareAndSet(false, true)) {
                    if (this.started.compareAndSet(true, false)) {
                        this.unregisterServiceInstance();
                        this.unexportMetadataService();
                        this.unexportServices();
                        this.unreferServices();
                    }
                    this.destroyServiceDiscoveries();
                    this.destroyExecutorRepository();
                    DubboShutdownHook.destroyAll();
                    this.clearConfigManager();
                    this.shutdownExecutor();
                    this.release();
                    ExtensionLoader exts = ExtensionLoader.getExtensionLoader(DubboBootstrapStartStopListener.class);
                    exts.getSupportedExtensionInstances().forEach(ext -> ext.onStop(this));
                }
            }
            finally {
                this.initialized.set(false);
                this.destroyLock.unlock();
            }
        }
    }

    private void destroyExecutorRepository() {
        ((ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).destroyAll();
    }

    private void destroyRegistries() {
        AbstractRegistryFactory.destroyAll();
    }

    private void destroyServiceDiscoveries() {
        AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> ThrowableAction.execute(() -> ((ServiceDiscovery)serviceDiscovery).destroy()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(NAME + "'s all ServiceDiscoveries have been destroyed.");
        }
    }

    private void clearConfigManager() {
        this.clearConfigs();
    }

    private void clearConfigs() {
        this.configManager.destroy();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(NAME + "'s configs have been clear.");
        }
    }

    private void release() {
        this.executeMutually(() -> {
            while (this.awaited.compareAndSet(false, true)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(NAME + " is about to shutdown...");
                }
                this.condition.signalAll();
            }
        });
    }

    private void shutdownExecutor() {
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void executeMutually(Runnable runnable) {
        try {
            this.lock.lock();
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ApplicationConfig getApplication() {
        ApplicationConfig application = this.configManager.getApplication().orElseGet(() -> {
            ApplicationConfig applicationConfig = new ApplicationConfig();
            this.configManager.setApplication(applicationConfig);
            return applicationConfig;
        });
        application.refresh();
        return application;
    }

    private MonitorConfig getMonitor() {
        MonitorConfig monitor = this.configManager.getMonitor().orElseGet(() -> {
            MonitorConfig monitorConfig = new MonitorConfig();
            this.configManager.setMonitor(monitorConfig);
            return monitorConfig;
        });
        monitor.refresh();
        return monitor;
    }

    private MetricsConfig getMetrics() {
        MetricsConfig metrics = this.configManager.getMetrics().orElseGet(() -> {
            MetricsConfig metricsConfig = new MetricsConfig();
            this.configManager.setMetrics(metricsConfig);
            return metricsConfig;
        });
        metrics.refresh();
        return metrics;
    }

    private ModuleConfig getModule() {
        ModuleConfig module = this.configManager.getModule().orElseGet(() -> {
            ModuleConfig moduleConfig = new ModuleConfig();
            this.configManager.setModule(moduleConfig);
            return moduleConfig;
        });
        module.refresh();
        return module;
    }

    private SslConfig getSsl() {
        SslConfig ssl = this.configManager.getSsl().orElseGet(() -> {
            SslConfig sslConfig = new SslConfig();
            this.configManager.setSsl(sslConfig);
            return sslConfig;
        });
        ssl.refresh();
        return ssl;
    }

    public void setReady(boolean ready) {
        this.ready.set(ready);
    }

    @Deprecated
    public static void reset() {
        DubboBootstrap.reset(true);
    }

    @Deprecated
    public static void reset(boolean destroy) {
        DubboShutdownHook.reset();
        if (destroy) {
            if (instance != null) {
                instance.destroy();
                instance = null;
            }
            ApplicationModel.reset();
            AbstractRegistryFactory.reset();
            MetadataReportInstance.destroy();
            AbstractMetadataReportFactory.clear();
            ExtensionLoader.resetExtensionLoader(DynamicConfigurationFactory.class);
            ExtensionLoader.resetExtensionLoader(MetadataReportFactory.class);
            ExtensionLoader.destroyAll();
        } else {
            instance = null;
            ApplicationModel.reset();
        }
    }
}

