/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metadata.WritableMetadataService;

public abstract class AbstractServiceNameMapping
implements ServiceNameMapping {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract Set<String> get(URL var1);

    public abstract Set<String> getAndListen(URL var1, MappingListener var2);

    @Override
    public Set<String> getServices(URL subscribedURL) {
        Set<String> cachedServices;
        TreeSet<String> subscribedServices = new TreeSet<String>();
        String serviceNames = subscribedURL.getParameter("provided-by");
        if (StringUtils.isNotEmpty((String)serviceNames)) {
            this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + serviceNames + " instructed by provided-by set by user.");
            subscribedServices.addAll(AbstractServiceNameMapping.parseServices(serviceNames));
        }
        if (CollectionUtils.isEmpty(subscribedServices) && !CollectionUtils.isEmpty(cachedServices = WritableMetadataService.getDefaultExtension().getCachedMapping(ServiceNameMapping.buildMappingKey(subscribedURL)))) {
            subscribedServices.addAll(cachedServices);
        }
        if (CollectionUtils.isEmpty(subscribedServices)) {
            Set<String> mappedServices = this.get(subscribedURL);
            this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + mappedServices + " instructed by remote metadata center.");
            subscribedServices.addAll(mappedServices);
            WritableMetadataService.getDefaultExtension().putCachedMapping(ServiceNameMapping.buildMappingKey(subscribedURL), subscribedServices);
        }
        return subscribedServices;
    }

    @Override
    public Set<String> getAndListenServices(URL registryURL, URL subscribedURL, MappingListener listener) {
        TreeSet<String> subscribedServices = new TreeSet<String>();
        Set<String> globalConfiguredSubscribingServices = AbstractServiceNameMapping.parseServices(registryURL.getParameter("subscribed-services"));
        String serviceNames = subscribedURL.getParameter("provided-by");
        if (StringUtils.isNotEmpty((String)serviceNames)) {
            this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + serviceNames + " instructed by provided-by set by user.");
            subscribedServices.addAll(AbstractServiceNameMapping.parseServices(serviceNames));
        }
        if (CollectionUtils.isEmpty(subscribedServices)) {
            Set<String> mappedServices = this.getAndListen(subscribedURL, listener);
            this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + mappedServices + " instructed by remote metadata center.");
            subscribedServices.addAll(mappedServices);
            if (CollectionUtils.isEmpty(subscribedServices)) {
                this.logger.info(subscribedURL.getServiceInterface() + " mapping to " + globalConfiguredSubscribingServices + " by default.");
                subscribedServices.addAll(globalConfiguredSubscribingServices);
            }
        }
        WritableMetadataService.getDefaultExtension().putCachedMapping(ServiceNameMapping.buildMappingKey(subscribedURL), subscribedServices);
        return subscribedServices;
    }

    static Set<String> parseServices(String literalServices) {
        return StringUtils.isBlank((CharSequence)literalServices) ? Collections.emptySet() : Collections.unmodifiableSet(Stream.of(literalServices.split(",")).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
    }
}

