/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.metadata.definition.builder.DefaultTypeBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class TypeDefinitionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitionBuilder.class);
    static final List<TypeBuilder> BUILDERS;
    private Map<String, TypeDefinition> typeCache = new HashMap<String, TypeDefinition>();

    public static TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> typeCache) {
        TypeDefinition td;
        TypeBuilder builder = TypeDefinitionBuilder.getGenericTypeBuilder(type, clazz);
        if (clazz.isPrimitive() || ClassUtils.isSimpleType(clazz)) {
            td = new TypeDefinition(clazz.getCanonicalName());
            typeCache.put(clazz.getCanonicalName(), td);
        } else {
            td = builder != null ? builder.build(type, clazz, typeCache) : DefaultTypeBuilder.build(clazz, typeCache);
        }
        return td;
    }

    private static TypeBuilder getGenericTypeBuilder(Type type, Class<?> clazz) {
        for (TypeBuilder builder : BUILDERS) {
            try {
                if (!builder.accept(type, clazz)) continue;
                return builder;
            }
            catch (NoClassDefFoundError cnfe) {
                logger.info("Throw classNotFound (" + cnfe.getMessage() + ") in " + builder.getClass());
            }
        }
        return null;
    }

    public TypeDefinition build(Type type, Class<?> clazz) {
        return TypeDefinitionBuilder.build(type, clazz, this.typeCache);
    }

    public List<TypeDefinition> getTypeDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeCache.values());
    }

    static {
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(TypeBuilder.class);
        Set tbs = extensionLoader.getSupportedExtensionInstances();
        BUILDERS = new ArrayList<TypeBuilder>(tbs);
    }
}

