/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class ArrayTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isArray();
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> typeCache) {
        String canonicalName = clazz.getCanonicalName();
        TypeDefinition td = typeCache.get(canonicalName);
        if (td != null) {
            return td;
        }
        td = new TypeDefinition(canonicalName);
        typeCache.put(canonicalName, td);
        Class<?> componentType = clazz.getComponentType();
        TypeDefinition itemTd = TypeDefinitionBuilder.build(componentType, componentType, typeCache);
        if (itemTd != null) {
            td.getItems().add(itemTd.getType());
        }
        return td;
    }
}

