/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;

public abstract class RegistryNotifier {
    private volatile long lastExecuteTime;
    private volatile long lastEventTime;
    private Object rawAddresses;
    private long delayTime;
    private ScheduledExecutorService scheduler;

    public RegistryNotifier(long delayTime) {
        this(delayTime, null);
    }

    public RegistryNotifier(long delayTime, ScheduledExecutorService scheduler) {
        this.delayTime = delayTime;
        this.scheduler = scheduler == null ? ((ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension()).getRegistryNotificationExecutor() : scheduler;
    }

    public synchronized void notify(Object rawAddresses) {
        long notifyTime;
        this.rawAddresses = rawAddresses;
        this.lastEventTime = notifyTime = System.currentTimeMillis();
        long delta = System.currentTimeMillis() - this.lastExecuteTime - this.delayTime;
        if (delta >= 0L) {
            this.scheduler.submit(new NotificationTask(this, notifyTime));
        } else {
            this.scheduler.schedule(new NotificationTask(this, notifyTime), -delta, TimeUnit.MILLISECONDS);
        }
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    protected abstract void doNotify(Object var1);

    public static class NotificationTask
    implements Runnable {
        private final RegistryNotifier listener;
        private final long time;

        public NotificationTask(RegistryNotifier listener, long time) {
            this.listener = listener;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.time == this.listener.lastEventTime) {
                this.listener.doNotify(this.listener.rawAddresses);
                this.listener.lastExecuteTime = System.currentTimeMillis();
                RegistryNotifier registryNotifier = this.listener;
                synchronized (registryNotifier) {
                    if (this.time == this.listener.lastEventTime) {
                        this.listener.rawAddresses = null;
                    }
                }
            }
        }
    }
}

