/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.URLStrParser;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.url.component.DubboServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceAddressURL;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.url.component.URLAddress;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;

public abstract class CacheableFailbackRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(CacheableFailbackRegistry.class);
    private static String[] VARIABLE_KEYS = new String[]{"timestamp%3D", "pid%3D"};
    protected static final Map<String, URLAddress> stringAddress = new ConcurrentHashMap<String, URLAddress>();
    protected static final Map<String, URLParam> stringParam = new ConcurrentHashMap<String, URLParam>();
    private static final ScheduledExecutorService cacheRemovalScheduler;
    private static final int cacheRemovalTaskIntervalInMillis;
    private static final int cacheClearWaitingThresholdInMillis;
    private static final Map<ServiceAddressURL, Long> waitForRemove;
    private static final Semaphore semaphore;
    private final Map<String, String> extraParameters;
    protected final Map<URL, Map<String, ServiceAddressURL>> stringUrls = new HashMap<URL, Map<String, ServiceAddressURL>>();

    public CacheableFailbackRegistry(URL url) {
        super(url);
        this.extraParameters = new HashMap<String, String>(8);
        this.extraParameters.put("check", String.valueOf(false));
    }

    protected static int getIntConfig(String key, int def) {
        String str = ConfigurationUtils.getProperty((String)key);
        int result = def;
        if (StringUtils.isNotEmpty((String)str)) {
            try {
                result = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid registry properties configuration key " + key + ", value " + str);
            }
        }
        return result;
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        this.evictURLCache(url);
    }

    protected void evictURLCache(URL url) {
        Map<String, ServiceAddressURL> oldURLs = this.stringUrls.remove(url);
        try {
            if (oldURLs != null && oldURLs.size() > 0) {
                logger.info("Evicting urls for service " + url.getServiceKey() + ", size " + oldURLs.size());
                Long currentTimestamp = System.currentTimeMillis();
                for (Map.Entry<String, ServiceAddressURL> entry : oldURLs.entrySet()) {
                    waitForRemove.put(entry.getValue(), currentTimestamp);
                }
                if (CollectionUtils.isNotEmptyMap(waitForRemove) && semaphore.tryAcquire()) {
                    cacheRemovalScheduler.schedule(new RemovalTask(), (long)cacheRemovalTaskIntervalInMillis, TimeUnit.MILLISECONDS);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to evict url for " + url.getServiceKey(), (Throwable)e);
        }
    }

    protected List<URL> toUrlsWithoutEmpty(URL consumer, Collection<String> providers) {
        HashMap<String, ServiceAddressURL> newURLs;
        Map<String, ServiceAddressURL> oldURLs = this.stringUrls.get(consumer);
        URL copyOfConsumer = this.removeParamsFromConsumer(consumer);
        if (oldURLs == null) {
            newURLs = new HashMap<String, ServiceAddressURL>();
            for (String rawProvider : providers) {
                ServiceAddressURL cachedURL = this.createURL(rawProvider = this.stripOffVariableKeys(rawProvider), copyOfConsumer, this.getExtraParameters());
                if (cachedURL == null) {
                    logger.warn("Invalid address, failed to parse into URL " + rawProvider);
                    continue;
                }
                newURLs.put(rawProvider, cachedURL);
            }
        } else {
            newURLs = new HashMap((int)((double)oldURLs.size() / 0.75 + 1.0));
            for (String rawProvider : providers) {
                ServiceAddressURL cachedURL = oldURLs.remove(rawProvider = this.stripOffVariableKeys(rawProvider));
                if (cachedURL == null && (cachedURL = this.createURL(rawProvider, copyOfConsumer, this.getExtraParameters())) == null) {
                    logger.warn("Invalid address, failed to parse into URL " + rawProvider);
                    continue;
                }
                newURLs.put(rawProvider, cachedURL);
            }
        }
        this.evictURLCache(consumer);
        this.stringUrls.put(consumer, newURLs);
        return new ArrayList<URL>(newURLs.values());
    }

    protected List<URL> toUrlsWithEmpty(URL consumer, String path, Collection<String> providers) {
        List<URL> urls = new ArrayList<URL>(1);
        boolean isProviderPath = path.endsWith("providers");
        if (isProviderPath) {
            if (CollectionUtils.isNotEmpty(providers)) {
                urls = this.toUrlsWithoutEmpty(consumer, providers);
            } else {
                this.evictURLCache(consumer);
            }
        } else if (CollectionUtils.isNotEmpty(providers)) {
            urls = this.toConfiguratorsWithoutEmpty(consumer, providers);
        }
        if (urls.isEmpty()) {
            int i = path.lastIndexOf("/");
            String category = i < 0 ? path : path.substring(i + 1);
            ServiceConfigURL empty = URLBuilder.from((URL)consumer).setProtocol("empty").addParameter("category", category).build();
            urls.add((URL)empty);
        }
        return urls;
    }

    protected ServiceAddressURL createURL(String rawProvider, URL consumerURL, Map<String, String> extraParameters) {
        String[] parts;
        boolean encoded = true;
        int paramStartIdx = rawProvider.indexOf("%3F");
        if (paramStartIdx == -1) {
            encoded = false;
        }
        if ((parts = URLStrParser.parseRawURLToArrays((String)rawProvider, (int)paramStartIdx)).length <= 1) {
            logger.warn("Received url without any parameters " + rawProvider);
            return DubboServiceAddressURL.valueOf((String)rawProvider, (URL)consumerURL);
        }
        String rawAddress = parts[0];
        String rawParams = parts[1];
        boolean isEncoded = encoded;
        URLAddress address = stringAddress.computeIfAbsent(rawAddress, k -> URLAddress.parse((String)k, (String)this.getDefaultURLProtocol(), (boolean)isEncoded));
        address.setTimestamp(System.currentTimeMillis());
        URLParam param = stringParam.computeIfAbsent(rawParams, k -> URLParam.parse((String)k, (boolean)isEncoded, (Map)extraParameters));
        param.setTimestamp(System.currentTimeMillis());
        ServiceAddressURL cachedURL = this.createServiceURL(address, param, consumerURL);
        if (this.isMatch(consumerURL, (URL)cachedURL)) {
            return cachedURL;
        }
        return null;
    }

    protected ServiceAddressURL createServiceURL(URLAddress address, URLParam param, URL consumerURL) {
        return new DubboServiceAddressURL(address, param, consumerURL, null);
    }

    protected URL removeParamsFromConsumer(URL consumer) {
        return consumer.removeParameters(DubboServiceAddressURL.PROVIDER_FIRST_KEYS);
    }

    private String stripOffVariableKeys(String rawProvider) {
        String[] keys = this.getVariableKeys();
        if (keys == null || keys.length == 0) {
            return rawProvider;
        }
        for (String key : keys) {
            int idxStart = rawProvider.indexOf(key);
            if (idxStart == -1) continue;
            int idxEnd = rawProvider.indexOf("%26", idxStart);
            String part1 = rawProvider.substring(0, idxStart);
            if (idxEnd == -1) {
                rawProvider = part1;
                continue;
            }
            String part2 = rawProvider.substring(idxEnd + "%26".length());
            rawProvider = part1 + part2;
        }
        if (rawProvider.endsWith("%26")) {
            rawProvider = rawProvider.substring(0, rawProvider.length() - "%26".length());
        }
        if (rawProvider.endsWith("%3F")) {
            rawProvider = rawProvider.substring(0, rawProvider.length() - "%3F".length());
        }
        return rawProvider;
    }

    private List<URL> toConfiguratorsWithoutEmpty(URL consumer, Collection<String> configurators) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (CollectionUtils.isNotEmpty(configurators)) {
            for (String provider : configurators) {
                URL url;
                if (!provider.contains(CommonConstants.PROTOCOL_SEPARATOR_ENCODED) || !UrlUtils.isMatch((URL)consumer, (URL)(url = URLStrParser.parseEncodedStr((String)provider)))) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    protected Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    protected String[] getVariableKeys() {
        return VARIABLE_KEYS;
    }

    protected String getDefaultURLProtocol() {
        return "dubbo";
    }

    @Deprecated
    protected Semaphore getSemaphore() {
        return semaphore;
    }

    protected abstract boolean isMatch(URL var1, URL var2);

    static {
        waitForRemove = new ConcurrentHashMap<ServiceAddressURL, Long>();
        semaphore = new Semaphore(1);
        ExecutorRepository executorRepository = (ExecutorRepository)ExtensionLoader.getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        cacheRemovalScheduler = executorRepository.nextScheduledExecutor();
        cacheRemovalTaskIntervalInMillis = CacheableFailbackRegistry.getIntConfig("dubbo.application.url.cache.task.interval", 120000);
        cacheClearWaitingThresholdInMillis = CacheableFailbackRegistry.getIntConfig("dubbo.application.url.cache.clear.waiting", 300000);
    }

    private static class RemovalTask
    implements Runnable {
        private RemovalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Clearing cached URLs, waiting to clear size " + waitForRemove.size());
            int clearCount = 0;
            try {
                Iterator it = waitForRemove.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ServiceAddressURL removeURL = (ServiceAddressURL)entry.getKey();
                    long removeTime = (Long)entry.getValue();
                    long current = System.currentTimeMillis();
                    if (current - removeTime < (long)cacheClearWaitingThresholdInMillis) continue;
                    URLAddress urlAddress = removeURL.getUrlAddress();
                    URLParam urlParam = removeURL.getUrlParam();
                    if (current - urlAddress.getTimestamp() >= (long)cacheClearWaitingThresholdInMillis) {
                        stringAddress.remove(urlAddress.getRawAddress());
                    }
                    if (current - urlParam.getTimestamp() >= (long)cacheClearWaitingThresholdInMillis) {
                        stringParam.remove(urlParam.getRawParam());
                    }
                    it.remove();
                    ++clearCount;
                }
            }
            catch (Throwable t) {
                logger.error("Error occurred when clearing cached URLs", t);
            }
            finally {
                semaphore.release();
            }
            logger.info("Clear cached URLs, size " + clearCount);
            if (CollectionUtils.isNotEmptyMap((Map)waitForRemove) && semaphore.tryAcquire()) {
                cacheRemovalScheduler.schedule(new RemovalTask(), (long)cacheRemovalTaskIntervalInMillis, TimeUnit.MILLISECONDS);
            }
        }
    }
}

