/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

public abstract class AbstractServiceDiscovery
implements ServiceDiscovery {
    private volatile boolean isDestroy;
    protected ServiceInstance serviceInstance;

    @Override
    public final ServiceInstance getLocalInstance() {
        return this.serviceInstance;
    }

    @Override
    public final void initialize(URL registryURL) throws Exception {
        this.doInitialize(registryURL);
    }

    public abstract void doInitialize(URL var1) throws Exception;

    @Override
    public final void register(ServiceInstance serviceInstance) throws RuntimeException {
        if (ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance) == null) {
            ServiceInstanceMetadataUtils.calInstanceRevision(this, serviceInstance);
        }
        this.doRegister(serviceInstance);
        this.serviceInstance = serviceInstance;
    }

    public abstract void doRegister(ServiceInstance var1) throws RuntimeException;

    @Override
    public final void update(ServiceInstance serviceInstance) throws RuntimeException {
        if (this.serviceInstance == null) {
            this.register(serviceInstance);
            return;
        }
        if (!ServiceInstanceMetadataUtils.isInstanceUpdated(serviceInstance)) {
            return;
        }
        this.doUpdate(serviceInstance);
        ServiceInstanceMetadataUtils.resetInstanceUpdateKey(serviceInstance);
        this.serviceInstance = serviceInstance;
    }

    public abstract void doUpdate(ServiceInstance var1) throws RuntimeException;

    @Override
    public final void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.doUnregister(serviceInstance);
    }

    public abstract void doUnregister(ServiceInstance var1);

    @Override
    public final void destroy() throws Exception {
        this.isDestroy = true;
        this.doDestroy();
    }

    public abstract void doDestroy() throws Exception;

    @Override
    public final boolean isDestroy() {
        return this.isDestroy;
    }
}

