/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.store.InMemoryWritableMetadataService;
import org.apache.dubbo.registry.client.metadata.store.RemoteMetadataServiceImpl;
import org.apache.dubbo.registry.integration.InterfaceCompatibleRegistryProtocol;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceMetadataUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceInstanceMetadataUtils.class);
    public static final String METADATA_SERVICE_PREFIX = "dubbo.metadata-service.";
    public static final String ENDPOINTS = "dubbo.endpoints";
    public static String METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME = "dubbo.metadata-service.url-params";
    public static final String METADATA_SERVICE_URLS_PROPERTY_NAME = "dubbo.metadata-service.urls";
    public static String EXPORTED_SERVICES_REVISION_PROPERTY_NAME = "dubbo.metadata.revision";
    public static String METADATA_STORAGE_TYPE_PROPERTY_NAME = "dubbo.metadata.storage-type";
    public static String METADATA_CLUSTER_PROPERTY_NAME = "dubbo.metadata.cluster";
    public static String INSTANCE_REVISION_UPDATED_KEY = "dubbo.instance.revision.updated";

    public static Map<String, String> getMetadataServiceURLsParams(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        String param = metadata.get(METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME);
        return StringUtils.isBlank((CharSequence)param) ? Collections.emptyMap() : (Map)new Gson().fromJson(param, Map.class);
    }

    public static String getMetadataServiceParameter(URL url) {
        url = url.removeParameter("application");
        url = url.removeParameter("group");
        url = url.removeParameter("deprecated");
        Map<String, String> params = ServiceInstanceMetadataUtils.getParams(url = url.removeParameter("timestamp"));
        if (params.isEmpty()) {
            return null;
        }
        return new Gson().toJson(params);
    }

    private static Map<String, String> getParams(URL providerURL) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ServiceInstanceMetadataUtils.setDefaultParams(params, providerURL);
        params.put("port", String.valueOf(providerURL.getPort()));
        params.put("protocol", providerURL.getProtocol());
        return params;
    }

    public static String getExportedServicesRevision(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.get(EXPORTED_SERVICES_REVISION_PROPERTY_NAME);
    }

    public static String getMetadataStorageType(URL registryURL) {
        return registryURL.getParameter(METADATA_STORAGE_TYPE_PROPERTY_NAME, "local");
    }

    public static String getMetadataStorageType(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.getOrDefault(METADATA_STORAGE_TYPE_PROPERTY_NAME, "local");
    }

    public static void setMetadataStorageType(ServiceInstance serviceInstance, String metadataType) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        metadata.put(METADATA_STORAGE_TYPE_PROPERTY_NAME, metadataType);
    }

    public static String getRemoteCluster(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.get(METADATA_CLUSTER_PROPERTY_NAME);
    }

    public static boolean hasEndpoints(ServiceInstance serviceInstance) {
        return StringUtils.isNotEmpty((String)serviceInstance.getMetadata().get(ENDPOINTS));
    }

    public static boolean isDubboServiceInstance(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.containsKey(METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME) || metadata.containsKey(METADATA_SERVICE_URLS_PROPERTY_NAME);
    }

    public static void setEndpoints(ServiceInstance serviceInstance, Map<String, Integer> protocolPorts) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        ArrayList endpoints = new ArrayList();
        protocolPorts.forEach((k, v) -> {
            DefaultServiceInstance.Endpoint endpoint = new DefaultServiceInstance.Endpoint((Integer)v, (String)k);
            endpoints.add(endpoint);
        });
        metadata.put(ENDPOINTS, new Gson().toJson(endpoints));
    }

    public static DefaultServiceInstance.Endpoint getEndpoint(ServiceInstance serviceInstance, String protocol) {
        List<DefaultServiceInstance.Endpoint> endpoints = ((DefaultServiceInstance)serviceInstance).getEndpoints();
        if (endpoints != null) {
            for (DefaultServiceInstance.Endpoint endpoint : endpoints) {
                if (!endpoint.getProtocol().equals(protocol)) continue;
                return endpoint;
            }
        }
        return null;
    }

    public static void calInstanceRevision(ServiceDiscovery serviceDiscovery, ServiceInstance instance) {
        WritableMetadataService writableMetadataService;
        MetadataInfo metadataInfo;
        String registryCluster;
        String string = registryCluster = serviceDiscovery.getUrl() == null ? "default" : serviceDiscovery.getUrl().getParameter("REGISTRY_CLUSTER");
        if (registryCluster == null) {
            registryCluster = "default";
        }
        if ((metadataInfo = (MetadataInfo)(writableMetadataService = WritableMetadataService.getDefaultExtension()).getMetadataInfos().get(registryCluster)) == null) {
            metadataInfo = ((InMemoryWritableMetadataService)writableMetadataService).getDefaultMetadataInfo();
        }
        if (metadataInfo != null) {
            String existingInstanceRevision = instance.getMetadata().get(EXPORTED_SERVICES_REVISION_PROPERTY_NAME);
            if (!metadataInfo.calAndGetRevision().equals(existingInstanceRevision)) {
                instance.getMetadata().put(EXPORTED_SERVICES_REVISION_PROPERTY_NAME, metadataInfo.calAndGetRevision());
                if (existingInstanceRevision != null) {
                    instance.getExtendParams().put(INSTANCE_REVISION_UPDATED_KEY, "true");
                }
            }
        }
    }

    public static boolean isInstanceUpdated(ServiceInstance instance) {
        return "true".equals(instance.getExtendParams().get(INSTANCE_REVISION_UPDATED_KEY));
    }

    public static void resetInstanceUpdateKey(ServiceInstance instance) {
        instance.getExtendParams().remove(INSTANCE_REVISION_UPDATED_KEY);
    }

    public static void refreshMetadataAndInstance(ServiceInstance serviceInstance) {
        RemoteMetadataServiceImpl remoteMetadataService = MetadataUtils.getRemoteMetadataService();
        remoteMetadataService.publishMetadata(ApplicationModel.getName());
        AbstractRegistryFactory.getServiceDiscoveries().forEach(serviceDiscovery -> {
            ServiceInstance instance = serviceDiscovery.getLocalInstance();
            if (instance == null) {
                LOGGER.warn("Refreshing of service instance started, but instance hasn't been registered yet.");
                instance = serviceInstance;
            }
            ServiceInstanceMetadataUtils.calInstanceRevision(serviceDiscovery, instance);
            ServiceInstanceMetadataUtils.customizeInstance(instance);
            if (serviceInstance.getPort() > 0) {
                serviceDiscovery.update(instance);
            }
        });
    }

    public static void customizeInstance(ServiceInstance instance) {
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(ServiceInstanceCustomizer.class);
        loader.getSupportedExtensionInstances().forEach(customizer -> customizer.customize(instance));
    }

    private static void setDefaultParams(Map<String, String> params, URL providerURL) {
        for (String parameterName : InterfaceCompatibleRegistryProtocol.DEFAULT_REGISTER_PROVIDER_KEYS) {
            String parameterValue = providerURL.getParameter(parameterName);
            if (StringUtils.isBlank((CharSequence)parameterValue)) continue;
            params.put(parameterName, parameterValue);
        }
    }
}

