/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.MigrationRuleHandler;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class MigrationRuleListener
implements RegistryProtocolListener,
ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRuleListener.class);
    private static final String DUBBO_SERVICEDISCOVERY_MIGRATION = "DUBBO_SERVICEDISCOVERY_MIGRATION";
    private static final String MIGRATION_DELAY_KEY = "dubbo.application.migration.delay";
    private final String RULE_KEY = ApplicationModel.getName() + ".migration";
    private final Map<MigrationInvoker, MigrationRuleHandler> handlers = new ConcurrentHashMap<MigrationInvoker, MigrationRuleHandler>();
    private final LinkedBlockingQueue<String> ruleQueue = new LinkedBlockingQueue();
    private final AtomicBoolean executorSubmit = new AtomicBoolean(false);
    private final ExecutorService ruleManageExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("Dubbo-Migration-Listener"));
    private DynamicConfiguration configuration = ApplicationModel.getEnvironment().getDynamicConfiguration().orElse(null);
    private volatile String rawRule;
    private volatile MigrationRule rule;

    public MigrationRuleListener() {
        if (this.configuration != null) {
            logger.info("Listening for migration rules on dataId " + this.RULE_KEY + ", group " + DUBBO_SERVICEDISCOVERY_MIGRATION);
            this.configuration.addListener(this.RULE_KEY, DUBBO_SERVICEDISCOVERY_MIGRATION, (ConfigurationListener)this);
            String rawRule = this.configuration.getConfig(this.RULE_KEY, DUBBO_SERVICEDISCOVERY_MIGRATION);
            if (StringUtils.isEmpty((String)rawRule)) {
                rawRule = "INIT";
            }
            this.setRawRule(rawRule);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Using default configuration rule because config center is not configured!");
            }
            this.setRawRule("INIT");
        }
        String localRawRule = ApplicationModel.getEnvironment().getLocalMigrationRule();
        if (!StringUtils.isEmpty((String)localRawRule)) {
            Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("DubboMigrationRuleDelayWorker", true)).schedule(() -> {
                if (this.rawRule.equals("INIT")) {
                    this.process(new ConfigChangedEvent(null, null, localRawRule));
                }
            }, (long)this.getDelay(), TimeUnit.MILLISECONDS);
        }
    }

    private int getDelay() {
        int delay = 60000;
        String delayStr = ConfigurationUtils.getProperty((String)MIGRATION_DELAY_KEY);
        if (StringUtils.isEmpty((String)delayStr)) {
            return delay;
        }
        try {
            delay = Integer.parseInt(delayStr);
        }
        catch (Exception e) {
            logger.warn("Invalid migration delay param " + delayStr);
        }
        return delay;
    }

    public synchronized void process(ConfigChangedEvent event) {
        String rawRule = event.getContent();
        if (StringUtils.isEmpty((String)rawRule)) {
            rawRule = "INIT";
        }
        try {
            this.ruleQueue.put(rawRule);
        }
        catch (InterruptedException e) {
            logger.error("Put rawRule to rule management queue failed. rawRule: " + rawRule, (Throwable)e);
        }
        if (this.executorSubmit.compareAndSet(false, true)) {
            this.ruleManageExecutor.submit(() -> {
                while (true) {
                    String rule = "";
                    try {
                        rule = this.ruleQueue.take();
                        if (StringUtils.isEmpty((String)rule)) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error("Poll Rule from config center failed.", (Throwable)e);
                    }
                    if (StringUtils.isEmpty((String)rule)) continue;
                    if (Objects.equals(this.rawRule, rule)) {
                        logger.info("Ignore duplicated rule");
                        continue;
                    }
                    try {
                        logger.info("Using the following migration rule to migrate:");
                        logger.info(rule);
                        this.setRawRule(rule);
                        if (!CollectionUtils.isNotEmptyMap(this.handlers)) continue;
                        ExecutorService executorService = Executors.newFixedThreadPool(100, (ThreadFactory)new NamedThreadFactory("Dubbo-Invoker-Migrate"));
                        CountDownLatch countDownLatch = new CountDownLatch(this.handlers.size());
                        this.handlers.forEach((_key, handler) -> executorService.submit(() -> {
                            try {
                                handler.doMigrate(this.rule);
                            }
                            finally {
                                countDownLatch.countDown();
                            }
                        }));
                        try {
                            countDownLatch.await(1L, TimeUnit.HOURS);
                        }
                        catch (InterruptedException e) {
                            logger.error("Wait Invoker Migrate interrupted!", (Throwable)e);
                        }
                        executorService.shutdown();
                        continue;
                    }
                    catch (Throwable t) {
                        logger.error("Error occurred when migration.", t);
                        continue;
                    }
                    break;
                }
            });
        }
    }

    public void setRawRule(String rawRule) {
        this.rawRule = rawRule;
        this.rule = this.parseRule(this.rawRule);
    }

    private MigrationRule parseRule(String rawRule) {
        MigrationRule tmpRule;
        MigrationRule migrationRule = tmpRule = this.rule == null ? MigrationRule.INIT : this.rule;
        if ("INIT".equals(rawRule)) {
            tmpRule = MigrationRule.INIT;
        } else {
            try {
                tmpRule = MigrationRule.parse(rawRule);
            }
            catch (Exception e) {
                logger.error("Failed to parse migration rule...", (Throwable)e);
            }
        }
        return tmpRule;
    }

    @Override
    public void onExport(RegistryProtocol registryProtocol, Exporter<?> exporter) {
    }

    @Override
    public void onRefer(RegistryProtocol registryProtocol, ClusterInvoker<?> invoker, URL consumerUrl, URL registryURL) {
        MigrationRuleHandler migrationRuleHandler = this.handlers.computeIfAbsent((MigrationInvoker)invoker, _key -> {
            ((MigrationInvoker)invoker).setMigrationRuleListener(this);
            return new MigrationRuleHandler((MigrationInvoker)invoker, consumerUrl);
        });
        migrationRuleHandler.doMigrate(this.rule);
    }

    @Override
    public void onDestroy() {
        if (this.configuration != null) {
            this.configuration.removeListener(this.RULE_KEY, (ConfigurationListener)this);
        }
    }

    public Map<MigrationInvoker, MigrationRuleHandler> getHandlers() {
        return this.handlers;
    }

    protected void removeMigrationInvoker(MigrationInvoker<?> migrationInvoker) {
        this.handlers.remove(migrationInvoker);
    }
}

