/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.ProtocolServiceKey;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceNotificationCustomizer;

public class SpringCloudServiceInstanceNotificationCustomizer
implements ServiceInstanceNotificationCustomizer {
    private static final String REST_PROTOCOL = "rest";

    @Override
    public void customize(List<ServiceInstance> serviceInstance) {
        if (serviceInstance.isEmpty()) {
            return;
        }
        if (!serviceInstance.stream().allMatch(instance -> "SPRING_CLOUD".equals(instance.getMetadata("preserved.register.source")))) {
            return;
        }
        for (final ServiceInstance instance2 : serviceInstance) {
            MetadataInfo.ServiceInfo serviceInfo = new MetadataInfo.ServiceInfo("*", "*", "*", REST_PROTOCOL, instance2.getPort(), "*", new HashMap());
            String revision = "SPRING_CLOUD-" + instance2.getServiceName() + "-" + instance2.getAddress() + "-" + instance2.getPort();
            MetadataInfo metadataInfo = new MetadataInfo(instance2.getServiceName(), revision, new ConcurrentHashMap<String, MetadataInfo.ServiceInfo>(Collections.singletonMap("*", serviceInfo))){

                public List<MetadataInfo.ServiceInfo> getMatchedServiceInfos(ProtocolServiceKey consumerProtocolServiceKey) {
                    String consumerProtocol = consumerProtocolServiceKey.getProtocol();
                    if (consumerProtocol != null && !SpringCloudServiceInstanceNotificationCustomizer.REST_PROTOCOL.equalsIgnoreCase(consumerProtocol)) {
                        return Collections.emptyList();
                    }
                    String protocol = consumerProtocol;
                    if (protocol == null) {
                        protocol = SpringCloudServiceInstanceNotificationCustomizer.REST_PROTOCOL;
                    }
                    this.getServices().putIfAbsent(consumerProtocolServiceKey.getServiceKeyString(), new MetadataInfo.ServiceInfo(consumerProtocolServiceKey.getInterfaceName(), consumerProtocolServiceKey.getGroup(), consumerProtocolServiceKey.getVersion(), protocol, instance2.getPort(), consumerProtocolServiceKey.getInterfaceName(), new HashMap()));
                    return super.getMatchedServiceInfos(consumerProtocolServiceKey);
                }
            };
            instance2.setServiceMetadata(metadataInfo);
        }
    }
}

