/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.Parameters;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.Server;
import org.apache.dubbo.remoting.exchange.ExchangeChannel;
import org.apache.dubbo.remoting.exchange.ExchangeServer;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.HeaderExchangeChannel;
import org.apache.dubbo.remoting.exchange.support.header.HeartbeatTimerTask;
import org.apache.dubbo.remoting.exchange.support.header.ReconnectTimerTask;

public class HeaderExchangeServer
implements ExchangeServer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Server server;
    private int heartbeat;
    private int heartbeatTimeout;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private HashedWheelTimer heartbeatTimer;

    public HeaderExchangeServer(Server server) {
        if (server == null) {
            throw new IllegalArgumentException("server == null");
        }
        this.server = server;
        this.heartbeat = server.getUrl().getParameter("heartbeat", 0);
        this.heartbeatTimeout = server.getUrl().getParameter("heartbeat.timeout", this.heartbeat * 3);
        if (this.heartbeatTimeout < this.heartbeat * 2) {
            throw new IllegalStateException("heartbeatTimeout < heartbeatInterval * 2");
        }
        this.startHeartbeatTimer();
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isClosed() {
        return this.server.isClosed();
    }

    private boolean isRunning() {
        Collection<Channel> channels = this.getChannels();
        for (Channel channel : channels) {
            if (!channel.isConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.doClose();
        this.server.close();
    }

    @Override
    public void close(int timeout) {
        this.startClose();
        if (timeout > 0) {
            long max = timeout;
            long start = System.currentTimeMillis();
            if (this.getUrl().getParameter("channel.readonly.send", true)) {
                this.sendChannelReadOnlyEvent();
            }
            while (this.isRunning() && System.currentTimeMillis() - start < max) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.doClose();
        this.server.close(timeout);
    }

    @Override
    public void startClose() {
        this.server.startClose();
    }

    private void sendChannelReadOnlyEvent() {
        Request request = new Request();
        request.setEvent("R");
        request.setTwoWay(false);
        request.setVersion(Version.getProtocolVersion());
        Collection<Channel> channels = this.getChannels();
        for (Channel channel : channels) {
            try {
                if (!channel.isConnected()) continue;
                channel.send(request, this.getUrl().getParameter("channel.readonly.sent", true));
            }
            catch (RemotingException e) {
                this.logger.warn("send cannot write message error.", (Throwable)e);
            }
        }
    }

    private void doClose() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.stopHeartbeatTimer();
    }

    @Override
    public Collection<ExchangeChannel> getExchangeChannels() {
        ArrayList<ExchangeChannel> exchangeChannels = new ArrayList<ExchangeChannel>();
        Collection<Channel> channels = this.server.getChannels();
        if (channels != null && !channels.isEmpty()) {
            for (Channel channel : channels) {
                exchangeChannels.add(HeaderExchangeChannel.getOrAddChannel(channel));
            }
        }
        return exchangeChannels;
    }

    @Override
    public ExchangeChannel getExchangeChannel(InetSocketAddress remoteAddress) {
        Channel channel = this.server.getChannel(remoteAddress);
        return HeaderExchangeChannel.getOrAddChannel(channel);
    }

    @Override
    public Collection<Channel> getChannels() {
        return this.getExchangeChannels();
    }

    @Override
    public Channel getChannel(InetSocketAddress remoteAddress) {
        return this.getExchangeChannel(remoteAddress);
    }

    @Override
    public boolean isBound() {
        return this.server.isBound();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.server.getLocalAddress();
    }

    @Override
    public URL getUrl() {
        return this.server.getUrl();
    }

    @Override
    public ChannelHandler getChannelHandler() {
        return this.server.getChannelHandler();
    }

    public void reset(URL url) {
        this.server.reset(url);
        try {
            if (url.hasParameter("heartbeat") || url.hasParameter("heartbeat.timeout")) {
                int h = url.getParameter("heartbeat", this.heartbeat);
                int t = url.getParameter("heartbeat.timeout", h * 3);
                if (t < h * 2) {
                    throw new IllegalStateException("heartbeatTimeout < heartbeatInterval * 2");
                }
                if (h != this.heartbeat || t != this.heartbeatTimeout) {
                    this.heartbeat = h;
                    this.heartbeatTimeout = t;
                    this.stopHeartbeatTimer();
                    this.startHeartbeatTimer();
                }
            }
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
        }
    }

    @Override
    @Deprecated
    public void reset(Parameters parameters) {
        this.reset(this.getUrl().addParameters(parameters.getParameters()));
    }

    @Override
    public void send(Object message) throws RemotingException {
        if (this.closed.get()) {
            throw new RemotingException(this.getLocalAddress(), null, "Failed to send message " + message + ", cause: The server " + this.getLocalAddress() + " is closed!");
        }
        this.server.send(message);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        if (this.closed.get()) {
            throw new RemotingException(this.getLocalAddress(), null, "Failed to send message " + message + ", cause: The server " + this.getLocalAddress() + " is closed!");
        }
        this.server.send(message, sent);
    }

    private long calculateLeastDuration(int time) {
        if (time / 3 <= 0) {
            return 1000L;
        }
        return time / 3;
    }

    private void startHeartbeatTimer() {
        long tickDuration = this.calculateLeastDuration(this.heartbeat);
        this.heartbeatTimer = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-server-heartbeat", true), tickDuration, TimeUnit.MILLISECONDS, 16);
        AbstractTimerTask.ChannelProvider cp = () -> Collections.unmodifiableCollection(this.getChannels());
        long heartbeatTick = this.calculateLeastDuration(this.heartbeat);
        long heartbeatTimeoutTick = this.calculateLeastDuration(this.heartbeatTimeout);
        HeartbeatTimerTask heartBeatTimerTask = new HeartbeatTimerTask(cp, heartbeatTick, this.heartbeat);
        ReconnectTimerTask reconnectTimerTask = new ReconnectTimerTask(cp, heartbeatTimeoutTick, this.heartbeatTimeout);
        this.heartbeatTimer.newTimeout((TimerTask)heartBeatTimerTask, heartbeatTick, TimeUnit.MILLISECONDS);
        this.heartbeatTimer.newTimeout((TimerTask)reconnectTimerTask, heartbeatTimeoutTick, TimeUnit.MILLISECONDS);
    }

    private void stopHeartbeatTimer() {
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.stop();
            this.heartbeatTimer = null;
        }
    }
}

