/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.api.Connection;

@ChannelHandler.Sharable
public class ConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    private static final AttributeKey<Boolean> GO_AWAY_KEY = AttributeKey.valueOf((String)"dubbo_channel_goaway");
    private final Connection connection;

    public ConnectionHandler(Connection connection) {
        this.connection = connection;
    }

    public void onGoAway(Channel channel) {
        Attribute attr = channel.attr(GO_AWAY_KEY);
        if (Boolean.TRUE.equals(attr.get())) {
            return;
        }
        attr.set((Object)true);
        if (this.connection != null) {
            this.connection.onGoaway(channel);
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Channel %s go away ,schedule reconnect", channel));
        }
        this.reconnect(channel);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
        if (!this.connection.isClosed()) {
            this.connection.onConnected(ctx.channel());
        } else {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.warn(String.format("Channel error:%s", ctx.channel()), cause);
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        Attribute goawayAttr = ctx.channel().attr(GO_AWAY_KEY);
        if (!Boolean.TRUE.equals(goawayAttr.get())) {
            this.reconnect(ctx.channel());
        }
    }

    private void reconnect(Channel channel) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Connection %s is reconnecting, attempt=%d", new Object[]{this.connection, 1}));
        }
        EventLoop eventLoop = channel.eventLoop();
        eventLoop.schedule(this.connection::connect, 1L, TimeUnit.SECONDS);
    }
}

