/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.apache.dubbo.common.config.CompositeConfiguration;
import org.apache.dubbo.remoting.Constants;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class NettyEventLoopFactory {
    public static final EventLoopGroup NIO_EVENT_LOOP_GROUP = NettyEventLoopFactory.eventLoopGroup(Constants.DEFAULT_IO_THREADS, "NettyClientWorker");

    public static EventLoopGroup eventLoopGroup(int threads, String threadFactoryName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadFactoryName, true);
        return NettyEventLoopFactory.shouldEpoll() ? new EpollEventLoopGroup(threads, (ThreadFactory)threadFactory) : new NioEventLoopGroup(threads, (ThreadFactory)threadFactory);
    }

    public static Class<? extends SocketChannel> socketChannelClass() {
        return NettyEventLoopFactory.shouldEpoll() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return NettyEventLoopFactory.shouldEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private static boolean shouldEpoll() {
        CompositeConfiguration configuration = ApplicationModel.getEnvironment().getConfiguration();
        if (configuration.getBoolean("netty.epoll.enable", false)) {
            String osName = configuration.getString("os.name");
            return osName.toLowerCase().contains("linux") && Epoll.isAvailable();
        }
        return false;
    }
}

