/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.resource.GlobalResourceInitializer;
import org.apache.dubbo.common.serialize.SerializationException;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;

public class DefaultFuture
extends CompletableFuture<Object> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DefaultFuture.class);
    private static final Map<Long, Channel> CHANNELS = new ConcurrentHashMap<Long, Channel>();
    private static final Map<Long, DefaultFuture> FUTURES = new ConcurrentHashMap<Long, DefaultFuture>();
    private static final GlobalResourceInitializer<Timer> TIME_OUT_TIMER = new GlobalResourceInitializer(() -> new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-future-timeout", true), 30L, TimeUnit.MILLISECONDS), DefaultFuture::destroy);
    private final Long id;
    private final Channel channel;
    private final Request request;
    private final int timeout;
    private final long start = System.currentTimeMillis();
    private volatile long sent;
    private Timeout timeoutCheckTask;
    private ExecutorService executor;

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private DefaultFuture(Channel channel, Request request, int timeout) {
        this.channel = channel;
        this.request = request;
        this.id = request.getId();
        this.timeout = timeout > 0 ? timeout : channel.getUrl().getPositiveParameter("timeout", 1000);
        FUTURES.put(this.id, this);
        CHANNELS.put(this.id, channel);
    }

    private static void timeoutCheck(DefaultFuture future) {
        TimeoutCheckTask task = new TimeoutCheckTask(future.getId());
        future.timeoutCheckTask = ((Timer)TIME_OUT_TIMER.get()).newTimeout((TimerTask)task, (long)future.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public static void destroy() {
        TIME_OUT_TIMER.remove(Timer::stop);
        FUTURES.clear();
        CHANNELS.clear();
    }

    public static DefaultFuture newFuture(Channel channel, Request request, int timeout, ExecutorService executor) {
        DefaultFuture future = new DefaultFuture(channel, request, timeout);
        future.setExecutor(executor);
        DefaultFuture.timeoutCheck(future);
        return future;
    }

    public static DefaultFuture getFuture(long id) {
        return FUTURES.get(id);
    }

    public static boolean hasFuture(Channel channel) {
        return CHANNELS.containsValue(channel);
    }

    public static void sent(Channel channel, Request request) {
        DefaultFuture future = FUTURES.get(request.getId());
        if (future != null) {
            future.doSent();
        }
    }

    public static void closeChannel(Channel channel, long timeout) {
        long deadline = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        for (Map.Entry<Long, Channel> entry : CHANNELS.entrySet()) {
            DefaultFuture future;
            if (!channel.equals(entry.getValue()) || (future = DefaultFuture.getFuture(entry.getKey())) == null || future.isDone()) continue;
            long restTime = deadline - System.currentTimeMillis();
            if (restTime > 0L) {
                try {
                    future.get(restTime, TimeUnit.MILLISECONDS);
                }
                catch (java.util.concurrent.TimeoutException ignore) {
                    logger.warn("4-13", "", "", "Trying to close channel " + channel + ", but response is not received in " + timeout + "ms, and the request id is " + future.id);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (future.isDone()) continue;
            DefaultFuture.respInactive(channel, future);
        }
    }

    private static void respInactive(Channel channel, DefaultFuture future) {
        Response disconnectResponse = new Response(future.getId());
        disconnectResponse.setStatus((byte)35);
        disconnectResponse.setErrorMessage("Channel " + channel + " is inactive. Directly return the unFinished request : " + (logger.isDebugEnabled() ? future.getRequest() : future.getRequest().copyWithoutData()));
        DefaultFuture.received(channel, disconnectResponse);
    }

    public static void received(Channel channel, Response response) {
        DefaultFuture.received(channel, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void received(Channel channel, Response response, boolean timeout) {
        try {
            DefaultFuture future = FUTURES.remove(response.getId());
            if (future != null) {
                Timeout t = future.timeoutCheckTask;
                if (!timeout) {
                    t.cancel();
                }
                future.doReceived(response);
                DefaultFuture.shutdownExecutorIfNeeded(future);
            } else {
                logger.warn("4-13", "", "", "The timeout response finally returned at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()) + ", response status is " + response.getStatus() + (channel == null ? "" : ", channel: " + channel.getLocalAddress() + " -> " + channel.getRemoteAddress()) + ", please check provider side for detailed result.");
            }
        }
        finally {
            CHANNELS.remove(response.getId());
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Response errorResult = new Response(this.id);
        errorResult.setStatus((byte)90);
        errorResult.setErrorMessage("request future has been canceled.");
        this.doReceived(errorResult);
        DefaultFuture future = FUTURES.remove(this.id);
        DefaultFuture.shutdownExecutorIfNeeded(future);
        CHANNELS.remove(this.id);
        this.timeoutCheckTask.cancel();
        return true;
    }

    private static void shutdownExecutorIfNeeded(DefaultFuture future) {
        ExecutorService executor = future.getExecutor();
        if (executor instanceof ThreadlessExecutor && !executor.isShutdown()) {
            executor.shutdownNow();
        }
    }

    public void cancel() {
        this.cancel(true);
    }

    private void doReceived(Response res) {
        if (res == null) {
            throw new IllegalStateException("response cannot be null");
        }
        if (res.getStatus() == 20) {
            this.complete(res.getResult());
        } else if (res.getStatus() == 30 || res.getStatus() == 31) {
            this.completeExceptionally(new TimeoutException(res.getStatus() == 31, this.channel, res.getErrorMessage()));
        } else if (res.getStatus() == 25) {
            this.completeExceptionally((Throwable)new SerializationException(res.getErrorMessage()));
        } else {
            this.completeExceptionally(new RemotingException(this.channel, res.getErrorMessage()));
        }
    }

    private long getId() {
        return this.id;
    }

    private Channel getChannel() {
        return this.channel;
    }

    private boolean isSent() {
        return this.sent > 0L;
    }

    public Request getRequest() {
        return this.request;
    }

    private int getTimeout() {
        return this.timeout;
    }

    private void doSent() {
        this.sent = System.currentTimeMillis();
    }

    private String getTimeoutMessage(boolean scan) {
        long nowTimestamp = System.currentTimeMillis();
        return (this.sent > 0L ? "Waiting server-side response timeout" : "Sending request timeout in client-side") + (scan ? " by scan timer" : "") + ". start time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.start)) + ", end time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(nowTimestamp)) + "," + (this.sent > 0L ? " client elapsed: " + (this.sent - this.start) + " ms, server elapsed: " + (nowTimestamp - this.sent) : " elapsed: " + (nowTimestamp - this.start)) + " ms, timeout: " + this.timeout + " ms, request: " + (logger.isDebugEnabled() ? this.request : this.request.copyWithoutData()) + ", channel: " + this.channel.getLocalAddress() + " -> " + this.channel.getRemoteAddress();
    }

    private static class TimeoutCheckTask
    implements TimerTask {
        private final Long requestID;

        TimeoutCheckTask(Long requestID) {
            this.requestID = requestID;
        }

        public void run(Timeout timeout) {
            DefaultFuture future = DefaultFuture.getFuture(this.requestID);
            if (future == null || future.isDone()) {
                return;
            }
            ExecutorService executor = future.getExecutor();
            if (executor != null && !executor.isShutdown()) {
                executor.execute(() -> this.notifyTimeout(future));
            } else {
                this.notifyTimeout(future);
            }
        }

        private void notifyTimeout(DefaultFuture future) {
            Response timeoutResponse = new Response(future.getId());
            timeoutResponse.setStatus(future.isSent() ? (byte)31 : 30);
            timeoutResponse.setErrorMessage(future.getTimeoutMessage(true));
            DefaultFuture.received(future.getChannel(), timeoutResponse, true);
        }
    }
}

