/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"}, order=-2147483648)
public class ProfilerServerFilter
implements Filter,
BaseFilter.Listener {
    private static final String CLIENT_IP_KEY = "client_ip";
    private static final Logger logger = LoggerFactory.getLogger(ProfilerServerFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (ProfilerSwitch.isEnableSimpleProfiler()) {
            Object localInvokeProfiler = invocation.get("DUBBO_INVOKE_PROFILER");
            ProfilerEntry bizProfiler = localInvokeProfiler instanceof ProfilerEntry ? Profiler.enter((ProfilerEntry)((ProfilerEntry)localInvokeProfiler), (String)"Receive request. Local server invoke begin.") : Profiler.start((String)"Receive request. Server invoke begin.");
            invocation.put("DUBBO_INVOKE_PROFILER", bizProfiler);
            invocation.put(CLIENT_IP_KEY, RpcContext.getServiceContext().getRemoteAddressString());
        }
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        this.afterInvoke(invoker, invocation);
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.afterInvoke(invoker, invocation);
    }

    private void afterInvoke(Invoker<?> invoker, Invocation invocation) {
        Object fromInvocation;
        if (ProfilerSwitch.isEnableSimpleProfiler() && (fromInvocation = invocation.get("DUBBO_INVOKE_PROFILER")) instanceof ProfilerEntry) {
            ProfilerEntry profiler = Profiler.release((ProfilerEntry)((ProfilerEntry)fromInvocation));
            invocation.put("DUBBO_INVOKE_PROFILER", profiler);
            this.dumpIfNeed(invoker, invocation, (ProfilerEntry)fromInvocation);
        }
    }

    private void dumpIfNeed(Invoker<?> invoker, Invocation invocation, ProfilerEntry profiler) {
        Object timeoutValue = invocation.getObjectAttachmentWithoutConvert("timeout");
        int timeout = timeoutValue instanceof Integer ? ((Integer)timeoutValue).intValue() : invoker.getUrl().getMethodPositiveParameter(invocation.getMethodName(), "timeout", 1000);
        long usage = profiler.getEndTime() - profiler.getStartTime();
        if ((double)usage / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout && timeout != -1) {
            StringBuilder attachment = new StringBuilder();
            invocation.foreachAttachment(entry -> attachment.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";\n"));
            logger.warn(String.format("[Dubbo-Provider] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\nclient: %s\ninvocation context:\n%sthread info: \n%s", invocation.getTargetServiceUniqueName(), invocation.getMethodName(), usage / 1000000L, usage % 1000000L, timeout, invocation.get(CLIENT_IP_KEY), attachment, Profiler.buildDetail((ProfilerEntry)profiler)));
        }
    }
}

