/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.dubbo.common.Experimental;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadlocal.InternalThreadLocal;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncContext;
import org.apache.dubbo.rpc.AttachmentsAdapter;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcServiceContext;

public class RpcContext {
    private static final RpcContext AGENT = new RpcContext();
    private static final InternalThreadLocal<RpcContextAttachment> SERVER_LOCAL = new InternalThreadLocal<RpcContextAttachment>(){

        protected RpcContextAttachment initialValue() {
            return new RpcContextAttachment();
        }
    };
    private static final InternalThreadLocal<RpcContextAttachment> CLIENT_ATTACHMENT = new InternalThreadLocal<RpcContextAttachment>(){

        protected RpcContextAttachment initialValue() {
            return new RpcContextAttachment();
        }
    };
    private static final InternalThreadLocal<RpcContextAttachment> SERVER_ATTACHMENT = new InternalThreadLocal<RpcContextAttachment>(){

        protected RpcContextAttachment initialValue() {
            return new RpcContextAttachment();
        }
    };
    private static final InternalThreadLocal<RpcServiceContext> SERVICE_CONTEXT = new InternalThreadLocal<RpcServiceContext>(){

        protected RpcServiceContext initialValue() {
            return new RpcServiceContext();
        }
    };
    private static final InternalThreadLocal<CancellationContext> CANCELLATION_CONTEXT = new InternalThreadLocal<CancellationContext>(){

        protected CancellationContext initialValue() {
            return new CancellationContext();
        }
    };
    private boolean remove = true;

    public static CancellationContext getCancellationContext() {
        return (CancellationContext)CANCELLATION_CONTEXT.get();
    }

    public static void removeCancellationContext() {
        CANCELLATION_CONTEXT.remove();
    }

    public static void restoreCancellationContext(CancellationContext oldContext) {
        CANCELLATION_CONTEXT.set((Object)oldContext);
    }

    protected RpcContext() {
    }

    public static RpcContextAttachment getServerContext() {
        return (RpcContextAttachment)SERVER_LOCAL.get();
    }

    public static void removeServerContext() {
        SERVER_LOCAL.remove();
    }

    @Deprecated
    public static RpcContext getContext() {
        return AGENT;
    }

    public static RpcContextAttachment getClientAttachment() {
        return (RpcContextAttachment)CLIENT_ATTACHMENT.get();
    }

    public static RpcContextAttachment getServerAttachment() {
        return (RpcContextAttachment)SERVER_ATTACHMENT.get();
    }

    public boolean canRemove() {
        return this.remove;
    }

    public void clearAfterEachInvoke(boolean remove) {
        this.remove = remove;
    }

    public static RpcServiceContext getServiceContext() {
        return (RpcServiceContext)SERVICE_CONTEXT.get();
    }

    public static void removeServiceContext() {
        SERVICE_CONTEXT.remove();
    }

    public static void removeClientAttachment() {
        if (((RpcContextAttachment)CLIENT_ATTACHMENT.get()).canRemove()) {
            CLIENT_ATTACHMENT.remove();
        }
    }

    public static void removeServerAttachment() {
        if (((RpcContextAttachment)SERVER_ATTACHMENT.get()).canRemove()) {
            SERVER_ATTACHMENT.remove();
        }
    }

    public static void removeContext() {
        if (((RpcContextAttachment)CLIENT_ATTACHMENT.get()).canRemove()) {
            CLIENT_ATTACHMENT.remove();
        }
        if (((RpcContextAttachment)SERVER_ATTACHMENT.get()).canRemove()) {
            SERVER_ATTACHMENT.remove();
        }
        SERVER_LOCAL.remove();
        SERVICE_CONTEXT.remove();
        CANCELLATION_CONTEXT.remove();
    }

    public Object getRequest() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRequest();
    }

    public void setRequest(Object request) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setRequest(request);
    }

    public <T> T getRequest(Class<T> clazz) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRequest(clazz);
    }

    public Object getResponse() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getResponse();
    }

    public void setResponse(Object response) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setResponse(response);
    }

    public <T> T getResponse(Class<T> clazz) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getResponse(clazz);
    }

    public boolean isProviderSide() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).isProviderSide();
    }

    public boolean isConsumerSide() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).isConsumerSide();
    }

    public <T> CompletableFuture<T> getCompletableFuture() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getCompletableFuture();
    }

    public <T> Future<T> getFuture() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getFuture();
    }

    public void setFuture(CompletableFuture<?> future) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setFuture(future);
    }

    public List<URL> getUrls() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getUrls();
    }

    public void setUrls(List<URL> urls) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setUrls(urls);
    }

    public URL getUrl() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getUrl();
    }

    public void setUrl(URL url) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setUrl(url);
    }

    public String getMethodName() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getMethodName();
    }

    public void setMethodName(String methodName) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setMethodName(methodName);
    }

    public Class<?>[] getParameterTypes() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getParameterTypes();
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setParameterTypes(parameterTypes);
    }

    public Object[] getArguments() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getArguments();
    }

    public void setArguments(Object[] arguments) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setArguments(arguments);
    }

    public RpcContext setLocalAddress(String host, int port) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setLocalAddress(host, port);
    }

    public InetSocketAddress getLocalAddress() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getLocalAddress();
    }

    public RpcContext setLocalAddress(InetSocketAddress address) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setLocalAddress(address);
    }

    public String getLocalAddressString() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getLocalAddressString();
    }

    public String getLocalHostName() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getLocalHostName();
    }

    public RpcContext setRemoteAddress(String host, int port) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setRemoteAddress(host, port);
    }

    public InetSocketAddress getRemoteAddress() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRemoteAddress();
    }

    public RpcContext setRemoteAddress(InetSocketAddress address) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setRemoteAddress(address);
    }

    public String getRemoteApplicationName() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRemoteApplicationName();
    }

    public RpcContext setRemoteApplicationName(String remoteApplicationName) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setRemoteApplicationName(remoteApplicationName);
    }

    public String getRemoteAddressString() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRemoteAddressString();
    }

    public String getRemoteHostName() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRemoteHostName();
    }

    public String getLocalHost() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getLocalHost();
    }

    public int getLocalPort() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getLocalPort();
    }

    public String getRemoteHost() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRemoteHost();
    }

    public int getRemotePort() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getRemotePort();
    }

    public String getAttachment(String key) {
        String client = ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).getAttachment(key);
        if (StringUtils.isEmpty((String)client)) {
            return ((RpcContextAttachment)SERVER_ATTACHMENT.get()).getAttachment(key);
        }
        return client;
    }

    @Experimental(value="Experiment api for supporting Object transmission")
    public Object getObjectAttachment(String key) {
        Object client = ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).getObjectAttachment(key);
        if (client == null) {
            return ((RpcContextAttachment)SERVER_ATTACHMENT.get()).getObjectAttachment(key);
        }
        return client;
    }

    public RpcContext setAttachment(String key, String value) {
        return this.setObjectAttachment(key, value);
    }

    public RpcContext setAttachment(String key, Object value) {
        return this.setObjectAttachment(key, value);
    }

    @Experimental(value="Experiment api for supporting Object transmission")
    public RpcContext setObjectAttachment(String key, Object value) {
        ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).setObjectAttachment(key, value);
        return this;
    }

    public RpcContext removeAttachment(String key) {
        ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).removeAttachment(key);
        return this;
    }

    @Deprecated
    public Map<String, String> getAttachments() {
        return new AttachmentsAdapter.ObjectToStringMap(this.getObjectAttachments());
    }

    @Experimental(value="Experiment api for supporting Object transmission")
    public Map<String, Object> getObjectAttachments() {
        HashMap<String, Object> result = new HashMap<String, Object>((int)((double)(((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments.size() + ((RpcContextAttachment)RpcContext.SERVER_ATTACHMENT.get()).attachments.size()) / 0.75) + 1);
        result.putAll(((RpcContextAttachment)RpcContext.SERVER_ATTACHMENT.get()).attachments);
        result.putAll(((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments);
        return result;
    }

    public RpcContext setAttachments(Map<String, String> attachment) {
        ((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            ((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments.putAll(attachment);
        }
        return this;
    }

    @Experimental(value="Experiment api for supporting Object transmission")
    public RpcContext setObjectAttachments(Map<String, Object> attachment) {
        ((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            ((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments.putAll(attachment);
        }
        return this;
    }

    public void clearAttachments() {
        ((RpcContextAttachment)RpcContext.CLIENT_ATTACHMENT.get()).attachments.clear();
    }

    @Deprecated
    public Map<String, Object> get() {
        return ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).get();
    }

    @Deprecated
    public RpcContext set(String key, Object value) {
        ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).set(key, value);
        return this;
    }

    @Deprecated
    public RpcContext remove(String key) {
        ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).remove(key);
        return this;
    }

    @Deprecated
    public Object get(String key) {
        return ((RpcContextAttachment)CLIENT_ATTACHMENT.get()).get(key);
    }

    @Deprecated
    public boolean isServerSide() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).isServerSide();
    }

    @Deprecated
    public boolean isClientSide() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).isClientSide();
    }

    @Deprecated
    public List<Invoker<?>> getInvokers() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getInvokers();
    }

    public RpcContext setInvokers(List<Invoker<?>> invokers) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setInvokers((List)invokers);
    }

    @Deprecated
    public Invoker<?> getInvoker() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getInvoker();
    }

    public RpcContext setInvoker(Invoker<?> invoker) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setInvoker((Invoker)invoker);
    }

    @Deprecated
    public Invocation getInvocation() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getInvocation();
    }

    public RpcContext setInvocation(Invocation invocation) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).setInvocation(invocation);
    }

    public <T> CompletableFuture<T> asyncCall(Callable<T> callable) {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).asyncCall(callable);
    }

    public void asyncCall(Runnable runnable) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).asyncCall(runnable);
    }

    public static AsyncContext startAsync() throws IllegalStateException {
        return RpcContextAttachment.startAsync();
    }

    protected void setAsyncContext(AsyncContext asyncContext) {
        ((RpcContextAttachment)SERVER_ATTACHMENT.get()).setAsyncContext(asyncContext);
    }

    public boolean isAsyncStarted() {
        return ((RpcContextAttachment)SERVER_ATTACHMENT.get()).isAsyncStarted();
    }

    public boolean stopAsync() {
        return ((RpcContextAttachment)SERVER_ATTACHMENT.get()).stopAsync();
    }

    public AsyncContext getAsyncContext() {
        return ((RpcContextAttachment)SERVER_ATTACHMENT.get()).getAsyncContext();
    }

    public String getGroup() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getGroup();
    }

    public String getVersion() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getVersion();
    }

    public String getInterfaceName() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getInterfaceName();
    }

    public String getProtocol() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getProtocol();
    }

    public String getServiceKey() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getServiceKey();
    }

    public String getProtocolServiceKey() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getProtocolServiceKey();
    }

    public URL getConsumerUrl() {
        return ((RpcServiceContext)SERVICE_CONTEXT.get()).getConsumerUrl();
    }

    public void setConsumerUrl(URL consumerUrl) {
        ((RpcServiceContext)SERVICE_CONTEXT.get()).setConsumerUrl(consumerUrl);
    }

    @Deprecated
    public static void setRpcContext(URL url) {
        RpcServiceContext.getServiceContext().setConsumerUrl(url);
    }

    protected static RestoreContext clearAndStoreContext() {
        RestoreContext restoreContext = new RestoreContext();
        RpcContext.removeContext();
        return restoreContext;
    }

    protected static RestoreContext storeContext() {
        return new RestoreContext();
    }

    protected static void restoreContext(RestoreContext restoreContext) {
        if (restoreContext != null) {
            restoreContext.restore();
        }
    }

    public static class RestoreContext {
        private final RpcServiceContext serviceContext = RpcContext.getServiceContext().copyOf(false);
        private final RpcContextAttachment clientAttachment = RpcContext.getClientAttachment().copyOf(false);
        private final RpcContextAttachment serverAttachment = RpcContext.getServerAttachment().copyOf(false);
        private final RpcContextAttachment serverLocal = RpcContext.getServerContext().copyOf(false);

        public void restore() {
            if (this.serviceContext != null) {
                SERVICE_CONTEXT.set((Object)this.serviceContext);
            } else {
                RpcContext.removeServiceContext();
            }
            if (this.clientAttachment != null) {
                CLIENT_ATTACHMENT.set((Object)this.clientAttachment);
            } else {
                RpcContext.removeClientAttachment();
            }
            if (this.serverAttachment != null) {
                SERVER_ATTACHMENT.set((Object)this.serverAttachment);
            } else {
                RpcContext.removeServerAttachment();
            }
            if (this.serverLocal != null) {
                SERVER_LOCAL.set((Object)this.serverLocal);
            } else {
                RpcContext.removeServerContext();
            }
        }
    }
}

