/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AttachmentsAdapter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.support.RpcUtils;

public class RpcInvocation
implements Invocation,
Serializable {
    private static final long serialVersionUID = -4355285085441097045L;
    private String targetServiceUniqueName;
    private String protocolServiceKey;
    private ServiceModel serviceModel;
    private String methodName;
    private String interfaceName;
    private transient Class<?>[] parameterTypes;
    private String parameterTypesDesc;
    private String[] compatibleParamSignatures;
    private Object[] arguments;
    private Map<String, Object> attachments;
    private transient Lock attachmentLock = new ReentrantLock();
    private transient Map<Object, Object> attributes = Collections.synchronizedMap(new HashMap());
    private transient Invoker<?> invoker;
    private transient Class<?> returnType;
    private transient Type[] returnTypes;
    private transient InvokeMode invokeMode;

    @Deprecated
    public RpcInvocation() {
    }

    public RpcInvocation(Invocation invocation) {
        this(invocation, null);
    }

    public RpcInvocation(Invocation invocation, Invoker<?> invoker) {
        this(invocation.getTargetServiceUniqueName(), invocation.getServiceModel(), invocation.getMethodName(), invocation.getServiceName(), invocation.getProtocolServiceKey(), invocation.getParameterTypes(), invocation.getArguments(), invocation.copyObjectAttachments(), invocation.getInvoker(), invocation.getAttributes(), invocation instanceof RpcInvocation ? ((RpcInvocation)invocation).getInvokeMode() : null);
        if (invoker != null) {
            URL url = invoker.getUrl();
            this.setAttachment("path", url.getPath());
            if (url.hasParameter("interface")) {
                this.setAttachment("interface", url.getParameter("interface"));
            }
            if (url.hasParameter("group")) {
                this.setAttachment("group", url.getGroup());
            }
            if (url.hasParameter("version")) {
                this.setAttachment("version", url.getVersion("0.0.0"));
            }
            if (url.hasParameter("timeout")) {
                this.setAttachment("timeout", url.getParameter("timeout"));
            }
            if (url.hasParameter("token")) {
                this.setAttachment("token", url.getParameter("token"));
            }
            if (url.hasParameter("application")) {
                this.setAttachment("application", url.getApplication());
            }
        }
    }

    public RpcInvocation(ServiceModel serviceModel, String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments) {
        this(null, serviceModel, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, null, null, null, null);
    }

    @Deprecated
    public RpcInvocation(ServiceModel serviceModel, Method method, String interfaceName, String protocolServiceKey, Object[] arguments) {
        this(null, serviceModel, method.getName(), interfaceName, protocolServiceKey, method.getParameterTypes(), arguments, null, null, null, null);
    }

    @Deprecated
    public RpcInvocation(Method method, String interfaceName, String protocolServiceKey, Object[] arguments) {
        this(null, null, method.getName(), interfaceName, protocolServiceKey, method.getParameterTypes(), arguments, null, null, null, null);
    }

    @Deprecated
    public RpcInvocation(ServiceModel serviceModel, Method method, String interfaceName, String protocolServiceKey, Object[] arguments, Map<String, Object> attachment, Map<Object, Object> attributes) {
        this(null, serviceModel, method.getName(), interfaceName, protocolServiceKey, method.getParameterTypes(), arguments, attachment, null, attributes, null);
    }

    @Deprecated
    public RpcInvocation(Method method, String interfaceName, String protocolServiceKey, Object[] arguments, Map<String, Object> attachment, Map<Object, Object> attributes) {
        this(null, null, method.getName(), interfaceName, protocolServiceKey, method.getParameterTypes(), arguments, attachment, null, attributes, null);
    }

    @Deprecated
    public RpcInvocation(String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments) {
        this(null, null, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, null, null, null, null);
    }

    @Deprecated
    public RpcInvocation(ServiceModel serviceModel, String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments) {
        this(null, serviceModel, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, attachments, null, null, null);
    }

    @Deprecated
    public RpcInvocation(String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments) {
        this(null, null, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, attachments, null, null, null);
    }

    @Deprecated
    public RpcInvocation(String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments, Invoker<?> invoker, Map<Object, Object> attributes) {
        this(null, null, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, attachments, invoker, attributes, null);
    }

    @Deprecated
    public RpcInvocation(ServiceModel serviceModel, String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments, Invoker<?> invoker, Map<Object, Object> attributes) {
        this(null, serviceModel, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, attachments, invoker, attributes, null);
    }

    @Deprecated
    public RpcInvocation(ServiceModel serviceModel, String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments, Invoker<?> invoker, Map<Object, Object> attributes, InvokeMode invokeMode) {
        this(null, serviceModel, methodName, interfaceName, protocolServiceKey, parameterTypes, arguments, attachments, invoker, attributes, invokeMode);
    }

    public RpcInvocation(String targetServiceUniqueName, ServiceModel serviceModel, String methodName, String interfaceName, String protocolServiceKey, Class<?>[] parameterTypes, Object[] arguments, Map<String, Object> attachments, Invoker<?> invoker, Map<Object, Object> attributes, InvokeMode invokeMode) {
        this.targetServiceUniqueName = targetServiceUniqueName;
        this.serviceModel = serviceModel;
        this.methodName = methodName;
        this.interfaceName = interfaceName;
        this.protocolServiceKey = protocolServiceKey;
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
        this.arguments = arguments == null ? new Object[]{} : arguments;
        this.attachments = attachments == null ? new HashMap() : attachments;
        this.attributes = attributes == null ? Collections.synchronizedMap(new HashMap()) : attributes;
        this.invoker = invoker;
        this.initParameterDesc();
        this.invokeMode = invokeMode;
    }

    private void initParameterDesc() {
        MethodDescriptor methodDescriptor;
        AtomicReference<ServiceDescriptor> serviceDescriptor = new AtomicReference<ServiceDescriptor>();
        if (this.serviceModel != null) {
            serviceDescriptor.set(this.serviceModel.getServiceModel());
        } else if (StringUtils.isNotEmpty((String)this.interfaceName)) {
            FrameworkModel.defaultModel().getServiceRepository().allProviderModels().stream().map(ServiceModel::getServiceModel).filter(s -> this.interfaceName.equals(s.getInterfaceName())).findFirst().ifPresent(serviceDescriptor::set);
        }
        if (serviceDescriptor.get() != null && (methodDescriptor = ((ServiceDescriptor)serviceDescriptor.get()).getMethod(this.methodName, (Class[])this.parameterTypes)) != null) {
            this.parameterTypesDesc = methodDescriptor.getParamDesc();
            this.compatibleParamSignatures = methodDescriptor.getCompatibleParamSignatures();
            this.returnTypes = methodDescriptor.getReturnTypes();
            this.returnType = methodDescriptor.getReturnClass();
        }
        if (this.parameterTypesDesc == null) {
            this.parameterTypesDesc = ReflectUtils.getDesc((Class[])this.getParameterTypes());
            this.compatibleParamSignatures = (String[])Stream.of(this.parameterTypes).map(Class::getName).toArray(String[]::new);
            this.returnTypes = RpcUtils.getReturnTypes(this);
            this.returnType = RpcUtils.getReturnType(this);
        }
    }

    @Override
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker<?> invoker) {
        this.invoker = invoker;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getTargetServiceUniqueName() {
        return this.targetServiceUniqueName;
    }

    public void setTargetServiceUniqueName(String targetServiceUniqueName) {
        this.targetServiceUniqueName = targetServiceUniqueName;
    }

    @Override
    public String getProtocolServiceKey() {
        return this.protocolServiceKey;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public String getServiceName() {
        return this.interfaceName;
    }

    public void setServiceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
    }

    public String getParameterTypesDesc() {
        return this.parameterTypesDesc;
    }

    public void setParameterTypesDesc(String parameterTypesDesc) {
        this.parameterTypesDesc = parameterTypesDesc;
    }

    @Override
    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    public void setCompatibleParamSignatures(String[] compatibleParamSignatures) {
        this.compatibleParamSignatures = compatibleParamSignatures;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments == null ? new Object[]{} : arguments;
    }

    @Override
    public Map<String, Object> getObjectAttachments() {
        try {
            this.attachmentLock.lock();
            Map<String, Object> map = this.attachments;
            return map;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Override
    public Map<String, Object> copyObjectAttachments() {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                return hashMap;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.attachments);
            return hashMap;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Override
    public void foreachAttachment(Consumer<Map.Entry<String, Object>> consumer) {
        try {
            this.attachmentLock.lock();
            if (this.attachments != null) {
                this.attachments.entrySet().forEach(consumer);
            }
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    public void setObjectAttachments(Map<String, Object> attachments) {
        try {
            this.attachmentLock.lock();
            this.attachments = attachments == null ? new HashMap() : attachments;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Override
    public void setAttachment(String key, String value) {
        this.setObjectAttachment(key, value);
    }

    @Override
    @Deprecated
    public Map<String, String> getAttachments() {
        try {
            this.attachmentLock.lock();
            AttachmentsAdapter.ObjectToStringMap objectToStringMap = new AttachmentsAdapter.ObjectToStringMap(this.attachments);
            return objectToStringMap;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Deprecated
    public void setAttachments(Map<String, String> attachments) {
        try {
            this.attachmentLock.lock();
            this.attachments = attachments == null ? new HashMap<String, Object>() : new HashMap<String, String>(attachments);
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Override
    public void setAttachment(String key, Object value) {
        this.setObjectAttachment(key, value);
    }

    @Override
    public void setObjectAttachment(String key, Object value) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                this.attachments = new HashMap<String, Object>();
            }
            this.attachments.put(key, value);
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Override
    public void setAttachmentIfAbsent(String key, String value) {
        this.setObjectAttachmentIfAbsent(key, value);
    }

    @Override
    public void setAttachmentIfAbsent(String key, Object value) {
        this.setObjectAttachmentIfAbsent(key, value);
    }

    @Override
    public void setObjectAttachmentIfAbsent(String key, Object value) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                this.attachments = new HashMap<String, Object>();
            }
            if (!this.attachments.containsKey(key)) {
                this.attachments.put(key, value);
            }
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Deprecated
    public void addAttachments(Map<String, String> attachments) {
        try {
            this.attachmentLock.lock();
            if (attachments == null) {
                return;
            }
            if (this.attachments == null) {
                this.attachments = new HashMap<String, Object>();
            }
            this.attachments.putAll(attachments);
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    public void addObjectAttachments(Map<String, Object> attachments) {
        try {
            this.attachmentLock.lock();
            if (attachments == null) {
                return;
            }
            if (this.attachments == null) {
                this.attachments = new HashMap<String, Object>();
            }
            this.attachments.putAll(attachments);
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Deprecated
    public void addAttachmentsIfAbsent(Map<String, String> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            this.setAttachmentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    public void addObjectAttachmentsIfAbsent(Map<String, Object> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            this.setAttachmentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getAttachment(String key) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                String string = null;
                return string;
            }
            Object value = this.attachments.get(key);
            if (value instanceof String) {
                String string = (String)value;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectAttachment(String key) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object val = this.attachments.get(key);
            if (val != null) {
                Object object = val;
                return object;
            }
            Object object = this.attachments.get(key.toLowerCase(Locale.ROOT));
            return object;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getAttachment(String key, String defaultValue) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                String string = defaultValue;
                return string;
            }
            Object value = this.attachments.get(key);
            if (value instanceof String) {
                String strValue = (String)value;
                if (StringUtils.isEmpty((String)strValue)) {
                    String string = defaultValue;
                    return string;
                }
                String string = strValue;
                return string;
            }
            String string = defaultValue;
            return string;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Object getObjectAttachment(String key, Object defaultValue) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                Object object = defaultValue;
                return object;
            }
            Object value = this.attachments.get(key);
            if (value == null) {
                Object object = defaultValue;
                return object;
            }
            Object object = value;
            return object;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    @Override
    public Object getObjectAttachmentWithoutConvert(String key) {
        try {
            this.attachmentLock.lock();
            if (this.attachments == null) {
                Object var2_2 = null;
                return var2_2;
            }
            Object object = this.attachments.get(key);
            return object;
        }
        finally {
            this.attachmentLock.unlock();
        }
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    public void setReturnTypes(Type[] returnTypes) {
        this.returnTypes = returnTypes;
    }

    public InvokeMode getInvokeMode() {
        return this.invokeMode;
    }

    public void setInvokeMode(InvokeMode invokeMode) {
        this.invokeMode = invokeMode;
    }

    @Override
    public void setServiceModel(ServiceModel serviceModel) {
        this.serviceModel = serviceModel;
    }

    @Override
    public ServiceModel getServiceModel() {
        return this.serviceModel;
    }

    public String toString() {
        return "RpcInvocation [methodName=" + this.methodName + ", parameterTypes=" + Arrays.toString(this.parameterTypes) + ", arguments=" + Arrays.toString(this.arguments) + ", attachments=" + this.attachments + "]";
    }
}

