/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class Tag {
    Tag parent;
    String name;
    Map attributes = new TreeMap();
    Vector content = new Vector();
    static SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss.SSS");

    public Tag(String name) {
        this.name = name;
    }

    public Tag(String name, Map attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    public Tag(String name, String[] attributes) {
        this.name = name;
        for (int i = 0; i < attributes.length; i += 2) {
            this.addAttribute(attributes[i], attributes[i + 1]);
        }
    }

    public Tag(String name, String content) {
        this.name = name;
        this.addContent(content);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addAttribute(String key, Object value) {
        if (value == null) {
            return;
        }
        this.attributes.put(key, value.toString());
    }

    public void addAttribute(String key, int value) {
        this.attributes.put(key, Integer.toString(value));
    }

    public void addAttribute(String key, Date value) {
        this.attributes.put(key, format.format(value));
    }

    public void addContent(String string) {
        this.content.addElement(string);
    }

    public void addContent(Tag tag) {
        this.content.addElement(tag);
        tag.parent = this;
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public String getAttribute(String key, String deflt) {
        String answer = this.getAttribute(key);
        return answer == null ? deflt : answer;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Vector getContents() {
        return this.content;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(0, new PrintWriter(sw));
        return sw.toString();
    }

    public Vector getContents(String tag) {
        Vector out = new Vector();
        Enumeration e = this.content.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Tag) || !((Tag)o).getName().equals(tag)) continue;
            out.addElement(o);
        }
        return out;
    }

    public String getContentsAsString() {
        StringBuffer sb = new StringBuffer();
        this.getContentsAsString(sb);
        return sb.toString();
    }

    public void getContentsAsString(StringBuffer sb) {
        Enumeration e = this.content.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Tag) {
                ((Tag)o).getContentsAsString(sb);
                continue;
            }
            sb.append(o.toString());
        }
    }

    public void print(int indent, PrintWriter pw) {
        pw.print("\n");
        this.spaces(pw, indent);
        pw.print('<');
        pw.print(this.name);
        Object e = this.attributes.keySet().iterator();
        while (e.hasNext()) {
            String key = (String)e.next();
            String value = this.escape((String)this.attributes.get(key));
            pw.print(' ');
            pw.print(key);
            pw.print("=");
            String quote = "'";
            if (value.indexOf(quote) >= 0) {
                quote = "\"";
            }
            pw.print(quote);
            pw.print(value);
            pw.print(quote);
        }
        if (this.content.size() == 0) {
            pw.print('/');
        } else {
            pw.print('>');
            e = this.content.elements();
            while (e.hasMoreElements()) {
                Object content = e.nextElement();
                if (content instanceof String) {
                    this.formatted(pw, indent + 2, 60, this.escape((String)content));
                    continue;
                }
                if (!(content instanceof Tag)) continue;
                Tag tag = (Tag)content;
                tag.print(indent + 2, pw);
            }
            pw.print("\n");
            this.spaces(pw, indent);
            pw.print("</");
            pw.print(this.name);
        }
        pw.print('>');
    }

    void formatted(PrintWriter pw, int left, int width, String s) {
        int pos = width + 1;
        s = s.trim();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (i == 0 || Character.isWhitespace(c) && pos > width - 3) {
                pw.print("\n");
                this.spaces(pw, left);
                pos = 0;
            }
            switch (c) {
                case '<': {
                    pw.print("&lt;");
                    pos += 4;
                    continue block5;
                }
                case '>': {
                    pw.print("&gt;");
                    pos += 4;
                    continue block5;
                }
                case '&': {
                    pw.print("&amp;");
                    pos += 5;
                    continue block5;
                }
                default: {
                    pw.print(c);
                    ++pos;
                }
            }
        }
    }

    String escape(String s) {
        if (s == null) {
            return "?null?";
        }
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    void spaces(PrintWriter pw, int n) {
        while (n-- > 0) {
            pw.print(' ');
        }
    }

    public Tag[] select(String path) {
        return this.select(path, null);
    }

    public Tag[] select(String path, Tag mapping) {
        Vector v = new Vector();
        this.select(path, v, mapping);
        Object[] result = new Tag[v.size()];
        v.copyInto(result);
        return result;
    }

    void select(String path, Vector results, Tag mapping) {
        if (path.startsWith("//")) {
            int i = path.indexOf(47, 2);
            String name = path.substring(2, i < 0 ? path.length() : i);
            Enumeration e = this.content.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof Tag)) continue;
                Tag child = (Tag)o;
                if (this.match(name, child, mapping)) {
                    results.add(child);
                }
                child.select(path, results, mapping);
            }
            return;
        }
        if (path.length() == 0) {
            results.addElement(this);
            return;
        }
        int i = path.indexOf("/");
        String elementName = path;
        String remainder = "";
        if (i > 0) {
            elementName = path.substring(0, i);
            remainder = path.substring(i + 1);
        }
        Enumeration e = this.content.elements();
        while (e.hasMoreElements()) {
            Tag child;
            Object o = e.nextElement();
            if (!(o instanceof Tag) || !(child = (Tag)o).getName().equals(elementName) && !elementName.equals("*")) continue;
            child.select(remainder, results, mapping);
        }
    }

    public boolean match(String search, Tag child, Tag mapping) {
        int t;
        String target = child.getName();
        String sn = null;
        String tn = null;
        if (search.equals("*")) {
            return true;
        }
        int s = search.indexOf(58);
        if (s > 0) {
            sn = search.substring(0, s);
            search = search.substring(s + 1);
        }
        if ((t = target.indexOf(58)) > 0) {
            tn = target.substring(0, t);
            target = target.substring(t + 1);
        }
        if (!search.equals(target)) {
            return false;
        }
        if (mapping == null) {
            return tn == sn || sn != null && sn.equals(tn);
        }
        String suri = sn == null ? mapping.getAttribute("xmlns") : mapping.getAttribute("xmlns:" + sn);
        String turi = tn == null ? child.findRecursiveAttribute("xmlns") : child.findRecursiveAttribute("xmlns:" + tn);
        return turi == suri || turi != null && suri != null && turi.equals(suri);
    }

    public String getString(String path) {
        String attribute = null;
        int index = path.indexOf("@");
        if (index >= 0) {
            attribute = path.substring(index + 1);
            path = index > 0 ? path.substring(index - 1) : "";
        }
        Tag[] tags = this.select(path);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tags.length; ++i) {
            if (attribute == null) {
                tags[i].getContentsAsString(sb);
                continue;
            }
            sb.append(tags[i].getAttribute(attribute));
        }
        return sb.toString();
    }

    public String getStringContent() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.content.elements();
        while (e.hasMoreElements()) {
            Object c = e.nextElement();
            if (c instanceof Tag) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public String getNameSpace() {
        return this.getNameSpace(this.name);
    }

    public String getNameSpace(String name) {
        int index = name.indexOf(58);
        if (index > 0) {
            String ns = name.substring(0, index);
            return this.findRecursiveAttribute("xmlns:" + ns);
        }
        return this.findRecursiveAttribute("xmlns");
    }

    public String findRecursiveAttribute(String name) {
        String value = this.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.findRecursiveAttribute(name);
        }
        return null;
    }

    public String getLocalName() {
        int index = this.name.indexOf(58);
        if (index <= 0) {
            return this.name;
        }
        return this.name.substring(index + 1);
    }

    public void rename(String string) {
        this.name = string;
    }

    public static void convert(Collection c, String type, Tag parent) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Map map = (Map)i.next();
            parent.addContent(new Tag(type, map));
        }
    }
}

