/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyedBatchStatementExecutor<T, K>
implements JdbcBatchStatementExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyedBatchStatementExecutor.class);
    private final String sql;
    private final JdbcStatementBuilder<K> parameterSetter;
    private final Function<T, K> keyExtractor;
    private final Set<K> batch;
    private transient PreparedStatement st;

    KeyedBatchStatementExecutor(String sql, Function<T, K> keyExtractor, JdbcStatementBuilder<K> statementBuilder) {
        this.parameterSetter = statementBuilder;
        this.keyExtractor = keyExtractor;
        this.sql = sql;
        this.batch = new HashSet<K>();
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.st = connection.prepareStatement(this.sql);
    }

    @Override
    public void addToBatch(T record) {
        this.batch.add(this.keyExtractor.apply(record));
    }

    @Override
    public void executeBatch() throws SQLException {
        if (!this.batch.isEmpty()) {
            for (K entry : this.batch) {
                this.parameterSetter.accept(this.st, entry);
                this.st.addBatch();
            }
            this.st.executeBatch();
            this.batch.clear();
        }
    }

    @Override
    public void closeStatements() throws SQLException {
        if (this.st != null) {
            this.st.close();
            this.st = null;
        }
    }
}

