/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class CheckpointFailureManager {
    public static final int UNLIMITED_TOLERABLE_FAILURE_NUMBER = Integer.MAX_VALUE;
    private final int tolerableCpFailureNumber;
    private final FailJobCallback failureCallback;
    private final AtomicInteger continuousFailureCounter;
    private final Set<Long> countedCheckpointIds;

    public CheckpointFailureManager(int tolerableCpFailureNumber, FailJobCallback failureCallback) {
        Preconditions.checkArgument((tolerableCpFailureNumber >= 0 ? 1 : 0) != 0, (Object)"The tolerable checkpoint failure number is illegal, it must be greater than or equal to 0 .");
        this.tolerableCpFailureNumber = tolerableCpFailureNumber;
        this.continuousFailureCounter = new AtomicInteger(0);
        this.failureCallback = (FailJobCallback)Preconditions.checkNotNull((Object)failureCallback);
        this.countedCheckpointIds = ConcurrentHashMap.newKeySet();
    }

    public void handleJobLevelCheckpointException(CheckpointException exception, long checkpointId) {
        this.checkFailureCounter(exception, checkpointId);
        if (this.continuousFailureCounter.get() > this.tolerableCpFailureNumber) {
            this.clearCount();
            this.failureCallback.failJob((Throwable)new FlinkRuntimeException("Exceeded checkpoint tolerable failure threshold."));
        }
    }

    public void handleTaskLevelCheckpointException(CheckpointException exception, long checkpointId, ExecutionAttemptID executionAttemptID) {
        this.checkFailureCounter(exception, checkpointId);
        if (this.continuousFailureCounter.get() > this.tolerableCpFailureNumber) {
            this.clearCount();
            this.failureCallback.failJobDueToTaskFailure((Throwable)new FlinkRuntimeException("Exceeded checkpoint tolerable failure threshold."), executionAttemptID);
        }
    }

    public void checkFailureCounter(CheckpointException exception, long checkpointId) {
        if (this.tolerableCpFailureNumber == Integer.MAX_VALUE) {
            return;
        }
        CheckpointFailureReason reason = exception.getCheckpointFailureReason();
        switch (reason) {
            case PERIODIC_SCHEDULER_SHUTDOWN: 
            case ALREADY_QUEUED: 
            case TOO_MANY_CONCURRENT_CHECKPOINTS: 
            case MINIMUM_TIME_BETWEEN_CHECKPOINTS: 
            case NOT_ALL_REQUIRED_TASKS_RUNNING: 
            case CHECKPOINT_SUBSUMED: 
            case CHECKPOINT_COORDINATOR_SUSPEND: 
            case CHECKPOINT_COORDINATOR_SHUTDOWN: 
            case JOB_FAILURE: 
            case JOB_FAILOVER_REGION: 
            case CHECKPOINT_DECLINED_TASK_NOT_READY: 
            case CHECKPOINT_DECLINED_TASK_NOT_CHECKPOINTING: 
            case CHECKPOINT_DECLINED_ALIGNMENT_LIMIT_EXCEEDED: 
            case CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER: 
            case CHECKPOINT_DECLINED_SUBSUMED: 
            case CHECKPOINT_DECLINED_INPUT_END_OF_STREAM: 
            case EXCEPTION: 
            case CHECKPOINT_EXPIRED: 
            case TASK_CHECKPOINT_FAILURE: 
            case TRIGGER_CHECKPOINT_FAILURE: 
            case FINALIZE_CHECKPOINT_FAILURE: {
                break;
            }
            case CHECKPOINT_DECLINED: {
                if (!this.countedCheckpointIds.add(checkpointId)) break;
                this.continuousFailureCounter.incrementAndGet();
                break;
            }
            default: {
                throw new FlinkRuntimeException("Unknown checkpoint failure reason : " + reason.name());
            }
        }
    }

    public void handleCheckpointSuccess(long checkpointId) {
        this.clearCount();
    }

    private void clearCount() {
        this.continuousFailureCounter.set(0);
        this.countedCheckpointIds.clear();
    }

    void handleSynchronousSavepointFailure(Throwable cause) {
        if (!CheckpointFailureManager.isPreFlightFailure(cause)) {
            this.failureCallback.failJob(cause);
        }
    }

    private static boolean isPreFlightFailure(Throwable cause) {
        return ExceptionUtils.findThrowable((Throwable)cause, CheckpointException.class).map(CheckpointException::getCheckpointFailureReason).map(CheckpointFailureReason::isPreFlight).orElse(false);
    }

    public static interface FailJobCallback {
        public void failJob(Throwable var1);

        public void failJobDueToTaskFailure(Throwable var1, ExecutionAttemptID var2);
    }
}

