/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerConfiguration
implements TaskManagerRuntimeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerConfiguration.class);
    private final int numberSlots;
    private final ResourceProfile defaultSlotResourceProfile;
    private final ResourceProfile totalResourceProfile;
    private final String[] tmpDirectories;
    private final Time timeout;
    @Nullable
    private final Time maxRegistrationDuration;
    private final Time initialRegistrationPause;
    private final Time maxRegistrationPause;
    private final Time refusedRegistrationPause;
    private final UnmodifiableConfiguration configuration;
    private final boolean exitJvmOnOutOfMemory;
    private final FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder;
    private final String[] alwaysParentFirstLoaderPatterns;
    @Nullable
    private final String taskManagerLogPath;
    @Nullable
    private final String taskManagerStdoutPath;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;

    public TaskManagerConfiguration(int numberSlots, ResourceProfile defaultSlotResourceProfile, ResourceProfile totalResourceProfile, String[] tmpDirectories, Time timeout, @Nullable Time maxRegistrationDuration, Time initialRegistrationPause, Time maxRegistrationPause, Time refusedRegistrationPause, Configuration configuration, boolean exitJvmOnOutOfMemory, FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstLoaderPatterns, @Nullable String taskManagerLogPath, @Nullable String taskManagerStdoutPath, RetryingRegistrationConfiguration retryingRegistrationConfiguration) {
        this.numberSlots = numberSlots;
        this.defaultSlotResourceProfile = defaultSlotResourceProfile;
        this.totalResourceProfile = totalResourceProfile;
        this.tmpDirectories = (String[])Preconditions.checkNotNull((Object)tmpDirectories);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.maxRegistrationDuration = maxRegistrationDuration;
        this.initialRegistrationPause = (Time)Preconditions.checkNotNull((Object)initialRegistrationPause);
        this.maxRegistrationPause = (Time)Preconditions.checkNotNull((Object)maxRegistrationPause);
        this.refusedRegistrationPause = (Time)Preconditions.checkNotNull((Object)refusedRegistrationPause);
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.exitJvmOnOutOfMemory = exitJvmOnOutOfMemory;
        this.classLoaderResolveOrder = classLoaderResolveOrder;
        this.alwaysParentFirstLoaderPatterns = alwaysParentFirstLoaderPatterns;
        this.taskManagerLogPath = taskManagerLogPath;
        this.taskManagerStdoutPath = taskManagerStdoutPath;
        this.retryingRegistrationConfiguration = retryingRegistrationConfiguration;
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public ResourceProfile getDefaultSlotResourceProfile() {
        return this.defaultSlotResourceProfile;
    }

    public ResourceProfile getTotalResourceProfile() {
        return this.totalResourceProfile;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Time getMaxRegistrationDuration() {
        return this.maxRegistrationDuration;
    }

    public Time getInitialRegistrationPause() {
        return this.initialRegistrationPause;
    }

    @Nullable
    public Time getMaxRegistrationPause() {
        return this.maxRegistrationPause;
    }

    public Time getRefusedRegistrationPause() {
        return this.refusedRegistrationPause;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    @Override
    public boolean shouldExitJvmOnOutOfMemoryError() {
        return this.exitJvmOnOutOfMemory;
    }

    public FlinkUserCodeClassLoaders.ResolveOrder getClassLoaderResolveOrder() {
        return this.classLoaderResolveOrder;
    }

    public String[] getAlwaysParentFirstLoaderPatterns() {
        return this.alwaysParentFirstLoaderPatterns;
    }

    @Nullable
    public String getTaskManagerLogPath() {
        return this.taskManagerLogPath;
    }

    @Nullable
    public String getTaskManagerStdoutPath() {
        return this.taskManagerStdoutPath;
    }

    public RetryingRegistrationConfiguration getRetryingRegistrationConfiguration() {
        return this.retryingRegistrationConfiguration;
    }

    public static TaskManagerConfiguration fromConfiguration(Configuration configuration, TaskExecutorResourceSpec taskExecutorResourceSpec) {
        int extension;
        Time refusedRegistrationPause;
        Time maxRegistrationPause;
        Time initialRegistrationPause;
        Time finiteRegistrationDuration;
        Time timeout;
        int numberSlots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        if (numberSlots == -1) {
            numberSlots = 1;
        }
        String[] tmpDirPaths = ConfigurationUtils.parseTempDirectories((Configuration)configuration);
        try {
            timeout = AkkaUtils.getTimeoutAsTime(configuration);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid format for '" + AkkaOptions.ASK_TIMEOUT.key() + "'.Use formats like '50 s' or '1 min' to specify the timeout.");
        }
        LOG.info("Messages have a max timeout of " + timeout);
        try {
            Duration maxRegistrationDuration = (Duration)configuration.get(TaskManagerOptions.REGISTRATION_TIMEOUT);
            finiteRegistrationDuration = Time.milliseconds((long)maxRegistrationDuration.toMillis());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid format for parameter {}. Set the timeout to be infinite.", (Object)TaskManagerOptions.REGISTRATION_TIMEOUT.key());
            finiteRegistrationDuration = null;
        }
        try {
            Duration pause = (Duration)configuration.get(TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF);
            initialRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF.key(), e);
        }
        try {
            Duration pause = (Duration)configuration.get(TaskManagerOptions.REGISTRATION_MAX_BACKOFF);
            maxRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF.key(), e);
        }
        try {
            Duration pause = (Duration)configuration.get(TaskManagerOptions.REFUSED_REGISTRATION_BACKOFF);
            refusedRegistrationPause = Time.milliseconds((long)pause.toMillis());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid format for parameter " + TaskManagerOptions.INITIAL_REGISTRATION_BACKOFF.key(), e);
        }
        boolean exitOnOom = configuration.getBoolean(TaskManagerOptions.KILL_ON_OUT_OF_MEMORY);
        String classLoaderResolveOrder = configuration.getString(CoreOptions.CLASSLOADER_RESOLVE_ORDER);
        String[] alwaysParentFirstLoaderPatterns = CoreOptions.getParentFirstLoaderPatterns((Configuration)configuration);
        String taskManagerLogPath = configuration.getString("taskmanager.log.path", System.getProperty("log.file"));
        String taskManagerStdoutPath = taskManagerLogPath != null ? ((extension = taskManagerLogPath.lastIndexOf(46)) > 0 ? taskManagerLogPath.substring(0, extension) + ".out" : null) : null;
        RetryingRegistrationConfiguration retryingRegistrationConfiguration = RetryingRegistrationConfiguration.fromConfiguration(configuration);
        return new TaskManagerConfiguration(numberSlots, TaskExecutorResourceUtils.generateDefaultSlotResourceProfile(taskExecutorResourceSpec, numberSlots), TaskExecutorResourceUtils.generateTotalAvailableResourceProfile(taskExecutorResourceSpec), tmpDirPaths, timeout, finiteRegistrationDuration, initialRegistrationPause, maxRegistrationPause, refusedRegistrationPause, configuration, exitOnOom, FlinkUserCodeClassLoaders.ResolveOrder.fromString(classLoaderResolveOrder), alwaysParentFirstLoaderPatterns, taskManagerLogPath, taskManagerStdoutPath, retryingRegistrationConfiguration);
    }
}

