/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.partition;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.util.Preconditions;

public class ClusterPartitionReport
implements Serializable {
    private static final long serialVersionUID = -3150175198722481689L;
    private final Collection<ClusterPartitionReportEntry> entries;

    public ClusterPartitionReport(Collection<ClusterPartitionReportEntry> entries) {
        this.entries = (Collection)Preconditions.checkNotNull(entries);
    }

    public Collection<ClusterPartitionReportEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return "PartitionReport{entries=" + this.entries + '}';
    }

    public static class ClusterPartitionReportEntry
    implements Serializable {
        private static final long serialVersionUID = -666517548300250601L;
        private final IntermediateDataSetID dataSetId;
        private final Set<ResultPartitionID> hostedPartitions;
        private final int numTotalPartitions;

        public ClusterPartitionReportEntry(IntermediateDataSetID dataSetId, Set<ResultPartitionID> hostedPartitions, int numTotalPartitions) {
            this.dataSetId = dataSetId;
            this.hostedPartitions = hostedPartitions;
            this.numTotalPartitions = numTotalPartitions;
        }

        public IntermediateDataSetID getDataSetId() {
            return this.dataSetId;
        }

        public Set<ResultPartitionID> getHostedPartitions() {
            return this.hostedPartitions;
        }

        public int getNumTotalPartitions() {
            return this.numTotalPartitions;
        }
    }
}

