/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import org.apache.flink.runtime.checkpoint.channel.ChannelStateCheckpointWriter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequest;
import org.apache.flink.runtime.checkpoint.channel.CheckpointStartRequest;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.logger.NetworkActionsLogger;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.ThrowingConsumer;

interface ChannelStateWriteRequest {
    public long getCheckpointId();

    public void cancel(Throwable var1) throws Exception;

    public static CheckpointInProgressRequest completeInput(long checkpointId) {
        return new CheckpointInProgressRequest("completeInput", checkpointId, (ThrowingConsumer<ChannelStateCheckpointWriter, Exception>)((ThrowingConsumer)ChannelStateCheckpointWriter::completeInput), false);
    }

    public static CheckpointInProgressRequest completeOutput(long checkpointId) {
        return new CheckpointInProgressRequest("completeOutput", checkpointId, (ThrowingConsumer<ChannelStateCheckpointWriter, Exception>)((ThrowingConsumer)ChannelStateCheckpointWriter::completeOutput), false);
    }

    public static ChannelStateWriteRequest write(long checkpointId, InputChannelInfo info, CloseableIterator<Buffer> iterator) {
        return ChannelStateWriteRequest.buildWriteRequest(checkpointId, "ChannelStateWriteRequest#writeInput", info, iterator, (BiConsumerWithException<ChannelStateCheckpointWriter, Buffer, Exception>)((BiConsumerWithException)(writer, buffer) -> writer.writeInput(info, (Buffer)buffer)));
    }

    public static ChannelStateWriteRequest write(long checkpointId, ResultSubpartitionInfo info, Buffer ... buffers) {
        return ChannelStateWriteRequest.buildWriteRequest(checkpointId, "ChannelStateWriteRequest#writeOutput", info, (CloseableIterator<Buffer>)CloseableIterator.ofElements(Buffer::recycleBuffer, (Object[])buffers), (BiConsumerWithException<ChannelStateCheckpointWriter, Buffer, Exception>)((BiConsumerWithException)(writer, buffer) -> writer.writeOutput(info, (Buffer)buffer)));
    }

    public static ChannelStateWriteRequest buildWriteRequest(long checkpointId, String name, Object channelInfo, CloseableIterator<Buffer> iterator, BiConsumerWithException<ChannelStateCheckpointWriter, Buffer, Exception> bufferConsumer) {
        return new CheckpointInProgressRequest(name, checkpointId, (ThrowingConsumer<ChannelStateCheckpointWriter, Exception>)((ThrowingConsumer)writer -> {
            while (iterator.hasNext()) {
                Buffer buffer = (Buffer)iterator.next();
                NetworkActionsLogger.tracePersist(name, buffer, channelInfo, checkpointId);
                try {
                    Preconditions.checkArgument((boolean)buffer.isBuffer());
                }
                catch (Exception e) {
                    buffer.recycleBuffer();
                    throw e;
                }
                bufferConsumer.accept(writer, (Object)buffer);
            }
        }), (ThrowingConsumer<Throwable, Exception>)((ThrowingConsumer)throwable -> iterator.close()), false);
    }

    public static ChannelStateWriteRequest start(long checkpointId, ChannelStateWriter.ChannelStateWriteResult targetResult, CheckpointStorageLocationReference locationReference) {
        return new CheckpointStartRequest(checkpointId, targetResult, locationReference);
    }

    public static ChannelStateWriteRequest abort(long checkpointId, Throwable cause) {
        return new CheckpointInProgressRequest("abort", checkpointId, (ThrowingConsumer<ChannelStateCheckpointWriter, Exception>)((ThrowingConsumer)writer -> writer.fail(cause)), true);
    }

    public static ThrowingConsumer<Throwable, Exception> recycle(Buffer[] flinkBuffers) {
        return unused -> {
            for (Buffer b : flinkBuffers) {
                b.recycleBuffer();
            }
        };
    }
}

